/*===========================================================
 * eval.c -- Evaulate code of the program interpreter.
 * Copyright(c) by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 17 Aug 93 - modified
 *   Version 2.3.6 -  3 Nov 93 - modified
 *============================================================
 */
#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "interp.h"

/*===============================
 * evaluate -- Generic evaluator.
 *=============================*/
WORD evaluate (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	if (iistype(node, IIDENT)) return evaluate_iden(node, stab, eflg);
	if (iistype(node, IFUNC)) return evaluate_func(node, stab, eflg);
	*eflg = FALSE;
	if (iistype(node, IICONS)) return iicons(node);
	if (iistype(node, ILITERAL)) return iliteral(node);
	*eflg = TRUE;
	return NULL;
}
/*=======================================
 * evaluate_iden -- Interpret identifier.
 *=====================================*/
WORD evaluate_iden (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	STRING iden = iident(node);
	*eflg = FALSE;
	return valueof_iden(stab, iden);
}
/*===========================================
 * valueof_iden - Return value of identifier.
 *=========================================*/
WORD valueof_iden (stab, iden)
TABLE stab;  STRING iden;
{
	if (in_table(stab, iden)) return (WORD) valueof(stab, iden);
	return (WORD) valueof(globtab, iden);
}
/*===================================================
 * evaluate_cond - Interpret flow control expression.
 *=================================================*/
WORD evaluate_cond (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	WORD value;
	if (!inext(node)) return evaluate(node, stab, eflg);
	*eflg = TRUE;
	if (!iistype(node, IIDENT)) return NULL;
	value = evaluate(inext(node), stab, eflg);
	if (*eflg) return NULL;
	assign_iden(stab, iident(node), value);
	return value;
}
/*===============================================
 * evaluate_func - Interpret function or routine.
 *==============================================*/
WORD evaluate_func (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	WORD value;
	*eflg = TRUE;
	value = (*(FUNC)ifunc(node))(node, stab, eflg);
	if (*eflg) wprintf("error in %s\n", iident(node));
	return value;
}
/*======================================
 * iistype -- Check type of INTERP node.
 *====================================*/
BOOLEAN iistype (node, type)
INTERP node;
INT type;
{
	return itype(node) == type;
}
/*===============================================
 * num_params -- Return number of params in list.
 *=============================================*/
INT num_params (node)
INTERP node;
{
	INT np = 0;
	while (node) {
		np++;
		node = inext(node);
	}
	return np;
}
