/*=================================================================
 * screen.h -- Header file for screen I/O
 * Copyright (c) 1991 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 20 Aug 93 - modified
 *=================================================================
 */
#include <curses.h>
#include "panel.h"

#define HIDE(p) if(!panel_hidden(p)) hide_panel(p)
#define SHOW(p) if(panel_hidden(p)) show_panel(p)
#define MAIN_SCREEN       1
#define ONE_PERSON_SCREEN 2
#define ONE_FAMILY_SCREEN 3
#define TWO_PERSON_SCREEN 4
#define TWO_FAMILY_SCREEN 5
#define PEDIGREE_SCREEN   6
#define LIST_SCREEN       7
/*-----------------------------------------
 * WINDOWs and PANELs -- one for each menu.
 *---------------------------------------*/
extern INT cur_screen;
extern WINDOW *main_window;
extern PANEL *main_panel;
extern WINDOW *one_person_window;
extern PANEL *one_person_panel;
extern WINDOW *one_family_window;
extern PANEL *one_family_panel;
extern WINDOW *two_person_window;
extern PANEL *two_person_panel;
extern WINDOW *two_family_window;
extern PANEL *two_family_panel;
extern WINDOW *pedigree_window;
extern PANEL *pedigree_panel;
extern WINDOW *list_window;
extern PANEL *list_panel;
extern WINDOW *ask_window;
extern PANEL *ask_panel;
extern WINDOW *ask_msg_window;
extern PANEL *ask_msg_panel;
extern WINDOW *choose_from_list_win;
extern PANEL *choose_from_list_pnl;
extern WINDOW *start_menu_win;
extern PANEL *start_menu_pnl;
extern WINDOW *add_menu_win;
extern PANEL *add_menu_pnl;
extern WINDOW *del_menu_win;
extern PANEL *del_menu_pnl;
extern WINDOW *utils_menu_win;
extern PANEL *utils_menu_pnl;
