/*==============================================================
 * place.c -- Handles place values.
 * Copyright (c) 1993 by Thomas T. Wetmore; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.4 - 30 Aug 93 - modified
 *==============================================================
 */
#include "standard.h"

/*====================================================
 * place_to_list -- Convert place string to word list.
 *==================================================*/
BOOLEAN place_to_list (place, list, plen)
STRING place;
LIST list;
INT *plen;
{
	return value_to_list(place, list, plen, ',');
}
/*==============================================
 * value_to_list -- Convert string to word list.
 *============================================*/
BOOLEAN value_to_list (str, list, plen, dlm)
STRING str;
LIST list;
INT *plen;
INT dlm;
{
	static STRING buf = NULL;
	static INT len0 = 0;
	STRING p, q, n;
	INT len, c, i, j;

	if (!str || *str == 0 || !list) return FALSE;
	make_list_empty(list);
	set_list_type(list, LISTDOFREE);
	if ((len = strlen(str)) > len0 - 2) {
		if (buf) stdfree(buf);
		buf = (STRING) stdalloc(len0 = len + 20);
	}
	strcpy(buf, str);
	buf[len + 1] = 0;
	p = buf;
	j = 1;
	while (c = *p++) {
		if (c == dlm) {
			*(p - 1) = 0;
			j++;
		}
	}
	p = buf;
	for (i = 1;  i <= j;  i++) {
		n = p + strlen(p) + 1;
		while (chartype(c = *p++) == WHITE)
			;
		p--;
		q = p + strlen(p) - 1;
		while (q > p && chartype(*q) == WHITE)
			*q-- = 0;
		set_list_element(list, i, strsave(p));
		p = n;
	}
	*plen = j;
	return TRUE;
}
