/*=============================================================
 * signals.c -- Catch signals and exit
 * Copyright(c) 1993-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 01 Sep 93
 *   3.0.0 - 30 Jul 94
 *===========================================================*/

#include <signal.h>
#include "standard.h"

#define NUM_SIGNALS 21
STRING sig_msgs[] = {
	"SIGNAL 0",
	"HANGUP",
	"INTERRUPT",
	"QUIT",
	"ILLEGAL INSTRUCTION",
	"TRACE TRAP",
	"ABORT",
	"EMT INST",
	"FLOATING POINT EXCEPTION",
	"KILL",
	"BUS ERROR",
	"SEGMENTATION ERROR",
	"SYSTEM CALL ERROR",
	"PIPE WRITE",
	"ALARM CLOCK",
	"TEMINATE FROM KILL",
	"USER SIGNAL 1",
	"USER SIGNAL 2",
	"DEATH OF CHILD",
	"POWER-FAIL RESTART",
	"WINDOW CHANGE",
};
/*======================================
 * set_signals -- Install signal handler
 *====================================*/
set_signals ()
{
	extern void on_signals();
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, on_signals);
	signal(SIGHUP, on_signals);
	signal(SIGQUIT, on_signals);
	signal(SIGILL, on_signals);
#ifdef SIGEMT
	signal(SIGEMT, on_signals);
#endif
	signal(SIGFPE, on_signals);
	signal(SIGBUS, on_signals);
	signal(SIGSEGV, on_signals);
#ifdef SIGSYS
	signal(SIGSYS, on_signals);
#endif
	signal(SIGPIPE, on_signals);
}
/*======================================
 * on_signals -- Catch and handle signal
 *====================================*/
void on_signals (sig)
int sig;
{
	wprintf("signal %d:%s\n", sig, sig_msgs[sig]);
	close_lifelines();
	endwin();
	abort();
}
