/*======================================================
 * path.c -- Handle files with environment variables
 * Copyright (c) by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 12 Aug 93
 *   3.0.0 - 05 May 94
 *=====================================================*/

#include <unistd.h>
#include "standard.h"

/*===========================================
 * filepath -- Find file in sequence of paths
 *=========================================*/
STRING filepath (name, mode, path)
STRING name, mode, path;
{
	char buf1[100], buf2[100];
	STRING p, q;
	INT c;

	if (!name || *name == 0) return NULL;
	if (!path || *path == 0) return name;
	if (*name == '/' || *name == '.') return name;
	if (strlen(name) + strlen(path) >= 100) return NULL;
	strcpy(buf1, path);
	p = buf1;
	while (c = *p) {
		if (c == ':') *p = 0;
		p++;
	}
	*(++p) = 0;
	p = buf1;
	while (*p) {
		q = buf2;
		strcpy(q, p);
		q += strlen(q);
		strcpy(q, "/");
		q++;
		strcpy(q, name);
		if (access(buf2, 0) == 0) return strsave(buf2);
		p += strlen(p);
		p++;
	}
	if (!strcmp(mode, "r")) return NULL;
	p = buf1;
	q = buf2;
	strcpy(q, p);
	q += strlen(q);
	strcpy(q, "/");
	q++;
	strcpy(q, name);
	return strsave(buf2);
}
/*===========================================
 * fopenpath -- Open file using path variable
 *=========================================*/
FILE *fopenpath (name, mode, path)
STRING name, mode, path;
{
	STRING str;
	if (!(str = filepath(name, mode, path))) return NULL;
	return fopen(str, mode);
}
