/*================================================================
 * indiseq.h -- Header file for the INDISEQ data type.
 * Copyright(c) 1993 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 03 Aug 93 - modified
 *================================================================
 */
#ifndef BOOLEAN
#	define BOOLEAN int
#endif
#ifndef TRUE
#	define TRUE 1
#endif
#ifndef FALSE
#	define FALSE 0
#endif
/*===================================================================
 * SORTEL -- Data type for each element of an indi sequence.
 *   Key values are always present and belong to the data structure.
 *   Name values are always present for indi elements and belong to
 *   the data structure.  Values do not belong to the data structure.
 *=================================================================*/
typedef struct stag {
	STRING s_key;	/* person or family key */
	STRING s_nam;	/* name of person */
	WORD s_val;	/* any value */
	STRING s_prn;	/* menu print string */
	INT s_pri;	/* key as integer */
}
	*SORTEL;
#define skey(s) ((s)->s_key)
#define snam(s) ((s)->s_nam)
#define sval(s) ((s)->s_val)
#define spri(s) ((s)->s_pri)
#define sprn(s) ((s)->s_prn)
/*==================================================
 * INDISEQ -- Data type for an entire indi sequence.
 *================================================*/
typedef struct  {
	INT is_size;	/* current length of list  */
	INT is_max;	/* max length before increment */
	INT is_flags;	/* attribute flags */
	SORTEL *is_data;	/*  actual list of items */
}
	*INDISEQ;
#define ISize(s)  ((s)->is_size)
#define IMax(s)   ((s)->is_max)
#define IFlags(s) ((s)->is_flags)
#define IData(s)  ((s)->is_data)

#define KEYSORT   (1<<0)	/* Values of attribute flags */
#define NAMESORT  (1<<1)
#define UNIQUED   (1<<2)
#define VALUESORT (1<<3)

#define length_indiseq(seq)  (ISize(seq))

extern INDISEQ create_indiseq();
extern INDISEQ copy_indiseq();
extern INDISEQ indi_to_children();
extern INDISEQ fam_to_children();
extern INDISEQ indi_to_spouses();
extern INDISEQ indi_to_families();
extern INDISEQ name_to_indiseq();

#define FORINDISEQ(s,e,i)\
	{	int i, _n;\
		SORTEL e, *_d;\
		_d = IData((INDISEQ)s);\
		for (i = 0, _n = ISize((INDISEQ)s); i < _n; i++) {\
			e = _d[i];
#define ENDINDISEQ }}
