/* traverse.c - traverse a btree, doing things */
/* Version 2.3.4 - controlled 24 June 1993 */

#include "standard.h"
#include "btree.h"

/*========================================
 * traverse - Traverse BTREE, doing things
 *======================================*/
BOOLEAN traverse (btree, index, ifunc, dfunc)
BTREE btree;
INDEX index;
BOOLEAN (*ifunc)();
BOOLEAN (*dfunc)();
{
	INDEX newdex;
	STRING bdir = bbasedir(btree);

	if (index == NULL)
		return FALSE;
	if (itype(index) == BTINDEXTYPE) {
		INT i, n;
		if (ifunc != NULL && !(*ifunc)(btree, index))
			return FALSE;
		n = nkeys(index);
		for (i = 0; i <= n; i++) {
			BOOLEAN rc;
			newdex = readindex(bdir, fkeys(index, i));
			rc = traverse(btree, newdex, ifunc, dfunc);
			stdfree(newdex);
			if (!rc) return FALSE;
		}
		return TRUE;
	}
	if (dfunc != NULL)
		return (*dfunc)(btree, index);
	return TRUE;
}
