/*=============================================================
 * file.c -- File access to btree database
 * Copyright(c) 1991-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    3.0.0 - 24 Sep 94
 *===========================================================*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "standard.h"
#include "btree.h"

/*=========================================
 * addfile -- Add record to btree from file
 *=======================================*/
BOOLEAN addfile (btree, rkey, file)
BTREE btree;	/* btree to add to */
RKEY rkey;	/* key of new record */
STRING file;	/* file with new record */
{
	FILE *fp;
	STRING mem;
	INT len;
	struct stat buf;
	ASSERT(bwrite(btree));
	if ((fp = fopen(file, "r")) == NULL) return FALSE;
	if (fstat(fileno(fp), &buf) != 0) {
		fclose(fp);
		return FALSE;
	}
	if ((len = buf.st_size) == 0) {
		addrecord(btree, rkey, mem, 0);
		fclose(fp);
		return TRUE;
	}
	if ((mem = (STRING) stdalloc(buf.st_size)) == NULL) {
		fclose(fp);
		return FALSE;
	}
	if (fread(mem, buf.st_size, 1, fp) != 1) {
		fclose(fp);
		return FALSE;
	}
	addrecord(btree, rkey, mem, buf.st_size);
	stdfree(mem);
	fclose(fp);
	return TRUE;
}
/*===================================================
 * getfile -- Get record from btree and write to file
 *=================================================*/
BOOLEAN getfile (btree, rkey, file)
BTREE btree;	/* btree to get from */
RKEY rkey;	/* key of record */
STRING file;	/* file to write to */
{
	FILE *fp;
	INT len;
	RECORD record = getrecord(btree, rkey, &len);
	if (record == NULL) return FALSE;
	if ((fp = fopen(file, "w")) == NULL) {
		stdfree(record);
		return FALSE;
	}
	if (fwrite(record, len, 1, fp) != 1) {
		stdfree(record);
		fclose(fp);
		return FALSE;
	}
	stdfree(record);
	fclose(fp);
	return TRUE;
}
