/* TCP timeout routines */
#include <stdio.h>
#include "machdep.h"
#include "timer.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "ip.h"
#include "tcp.h"

/* Timer timeout */
void
tcp_timeout(arg)
int *arg;
{
	register struct tcb *tcb;

	tcb = (struct tcb *)arg;
	switch(tcb->state){
	case TIME_WAIT:		/* 2MSL timer has expired */
		close_self(tcb,NORMAL);
		break;
	default:		/* Retransmission timer has expired */
		if(tcb->retry < RETRY){
			tcb->retry++;
			tcb->backoff = min(tcb->backoff+1,BACKOFF);
			tcb->snd.ptr = tcb->snd.una;
			/* RTT is always measured from the FIRST transmission
			 * of a given sequence number, because in TCP there
			 * is no way to tell which (re)transmission a given
			 * ACK is for. This errs on the long (conservative)
			 * side when the path is lossy.
			 */
			tcb->rtt += tcb->timer.start;
			tcp_output(tcb);
		} else {
			/* Give up */
			close_self(tcb,TIMEOUT);
		}
	}
}
