/* OS- and machine-dependent stuff for IBM-PC running MS-DOS */
#include <stdio.h>
#include <sgtty.h>
#include "machdep.h"
#include "mbuf.h"
#include "internet.h"
#include "iface.h"
#include "pc.h"
#include "cmdparse.h"

struct asy asy[ASY_MAX];

/* Aztec memory allocation control */
int _STKLOW = 0;	/* Stack above heap */
int _STKSIZ = 10240/16;	/* 10K stack */
int _HEAPSIZ = 4096/16;	/* Isn't really used */
int _STKRED = 1024;	/* Size of red zone in bytes */

extern int asy0vec(),asy1vec();	/* ASY interrupt handlers */
int (*handle[])() = {asy0vec,asy1vec};
char *ttbuf;

/* Called at startup time to set up console I/O, memory heap */
ioinit()
{
	struct sgttyb ttybuf;
	register unsigned i;
	unsigned grabcore();
	char *malloc();

	/* Interrupts use a special stack deep in data space.
	 * Calls to sbrk() (invoked by malloc when it needs more memory
	 * from the system) at interrupt time will fail because sbrk()
	 * will think that the stack has overwritten the heap. So
	 * grab all the memory we can now for the heap so that malloc
	 * won't have to call sbrk and alloc_mbuf() won't fail unnecessarily
	 * at interrupt time.
	 */
	i = grabcore();

	ttbuf = malloc(BUFSIZ);
	setbuf(stdout,ttbuf);

	printf("Free space: %u bytes\r\n",i);

	ioctl(1,TIOCGETP,&ttybuf);
/*	ttybuf.sg_flags = RAW;
	ioctl(1,TIOCSETP,&ttybuf); */	/* TEMP FOR SDB */
}
/* Called just before exiting to restore console state */
iostop()
{
	struct sgttyb ttybuf;

	setbuf(stdout,NULLCHAR);
	free(ttbuf);
	ioctl(1,TIOCGETP,&ttybuf);
	ttybuf.sg_flags &= ~RAW;
	ioctl(1,TIOCSETP,&ttybuf);
	while(ifaces != NULLIF){
		if(ifaces->stop != NULLFP)
			(*ifaces->stop)(ifaces);
		ifaces = ifaces->next;
	}
}
/* Initialize asynch port "dev" */
int
asy_init(dev,bufsize)
int16 dev;
unsigned bufsize;
{
	register unsigned base;
	register struct fifo *fp;
	register struct asy *ap;
	unsigned short getcs();	/* Returns current CS */
	long getvec();

	ap = &asy[dev];
	/* Set up receiver FIFO */
	fp = &ap->fifo;
	if((fp->buf = malloc(bufsize)) == NULLCHAR){
		printf("asy%d: No space for rx buffer\r\n");
		fflush(stdout);
		return;
	}
	fp->bufsize = bufsize;
	fp->wp = fp->rp = fp->buf;
	fp->cnt = 0;

	base = ap->addr;

	/* Save original interrupt vector */
	ap->oldvec = getvec(8+ap->vec);

	/* Set interrupt vector to SIO handler */
	setvec(8+ap->vec,getcs(),(unsigned)handle[dev]);

	/* Purge the receive data buffer */
	(void)inportb(base+RBR);

	/* Set line control register: 8 bits, no parity */
	outportb(base+LCR,LCR_8BITS);

	/* Turn on receive interrupt enable in 8250, leave transmit
	 * and modem status interrupts turned off for now
	 */
	outportb(base+IER,IER_DAV);

	/* Set modem control register: assert DTR, RTS, turn on 8250
	 * master interrupt enable (connected to OUT2)
	 */
	outportb(base+MCR,MCR_DTR|MCR_RTS|MCR_OUT2);

	/* Clear mask (enable interrupt) in 8259 interrupt controller */
	clrbit(INTMASK,(char)(1<<ap->vec));
}
int
asy_stop(iface)
struct interface *iface;
{
	register unsigned base;
	register struct asy *ap;

	ap = &asy[iface->dev];
	base = ap->addr;
	/* Ensure that DLAB bit is off */
	outportb(base+LCR,LCR_8BITS);

	/* Turn off all 8250 interrupt enable bits */
	outportb(base+IER,0);

	/* Turn off DTR, RTS, master interrupt enable */
	outportb(base+MCR,0);

	/* Set 8259 interrupt mask (turn off interrupts) */
	setbit(INTMASK,(char)(1<<ap->vec));

	/* Restore original interrupt vector */
	setvec(8+ap->vec,(unsigned)(ap->oldvec >> 16),(unsigned)(ap->oldvec & 0xffff));
}

/* Set asynch line speed */
int
asy_setspeed(dev,speed)
int dev;
int speed;
{
	register unsigned base;
	register int divisor;
	int i_state;

	if(speed == 0 || dev >= nasy)
		return;
	
	base = asy[dev].addr;
	asy[dev].speed = speed;

	divisor = BAUDCLK / (long)speed;

	i_state = disable();

	/* Purge the receive data buffer */
	(void)inportb(base+RBR);

	/* Turn on divisor latch access bit */
	setbit(base+LCR,LCR_DLAB);

	/* Load the two bytes of the register */
	outportb(base+DLL,divisor & 0xff);		/* Low byte */
	outportb(base+DLM,(divisor >> 8) & 0xff);	/* Hi byte */

	/* Turn off divisor latch access bit */
	clrbit(base+LCR,LCR_DLAB);

	restore(i_state);
}
/* Send a buffer to serial transmitter */
asy_output(dev,buf,cnt)
unsigned dev;
char *buf;
unsigned short cnt;
{
	register struct dma *dp;
	unsigned base;
	char i_state;

	if(dev >= nasy)
		return;
	base = asy[dev].addr;
	dp = &asy[dev].dma;
	i_state = disable();
	if(dp->flags){
		restore(i_state);
		return;	/* Already busy */
	}
	dp->data = buf;
	dp->cnt = cnt;
	dp->flags = 1;
	/* Enable transmitter buffer empty interrupt and simulate
	 * an interrupt; this will get things rolling.
	 */
	setbit(base+IER,IER_TxE);
	asytxint(dev);
	restore(i_state);
}
/* Read characters from the keyboard, translating them to "real" ASCII
 * If none are ready, return the -1 from kbraw()
 */
int
kbread()
{
	int kbraw(),c;

	if((c = kbraw()) == 0){
		/* Lead-in to a special char */
		c = kbread();
		switch(c){
		case 3:		/* NULL (bizzare!) */
			c = 0;
			break;
		case 68:	/* F-10 key (used as command-mode escape) */
			c = -2;
			break;
		case 83:	/* DEL key */
			c = 0x7f;
			break;
		default:	/* Dunno what it is */
			c = -1;
		}
	}
	return c;
}
/* Receive characters from asynch line
 * Returns count of characters read
 */
unsigned
asy_recv(dev,buf,cnt)
int dev;
char *buf;
unsigned cnt;
{
	unsigned tot,n;
	int kbread();
	int i_state;
	struct fifo *fp;

	fp = &asy[dev].fifo;
	tot = 0;
	/* Read from serial I/O input buffer */
	i_state = disable();
	for(;;){
		n = min(cnt,fp->cnt);
		if(n == 0)
			break;
		n = min(n,&fp->buf[fp->bufsize] - fp->rp);
		movmem(fp->rp,buf,n);
		fp->rp += n;
		if(fp->rp >= &fp->buf[fp->bufsize])
			fp->rp = fp->buf;
		fp->cnt -= n;
		buf += n;
		tot += n;
		cnt -= n;
	}
	restore(i_state);
	return tot;

}
/* Interrupt handler for 8250 asynch chip */
asyint(dev)
unsigned dev;
{
	register unsigned base;
	register char iir;

	base = asy[dev].addr;
	while(((iir = inportb(base+IIR)) & IIR_IP) == 0){
		switch(iir & IIR_ID){
		case IIR_RDA:	/* Receiver interrupt */
			asyrxint(dev);
			break;
		case IIR_THRE:	/* Transmit interrupt */
			asytxint(dev);
			break;
		}
	}
}
/* Process 8250 receiver interrupts */
static
asyrxint(dev)
unsigned dev;
{
	unsigned base;
	register struct fifo *fp;
	char c;

	base = asy[dev].addr;
	fp = &asy[dev].fifo;
	while(inportb(base+LSR) & LSR_DR){
		c = inportb(base+RBR);
		/* Process incoming data;
		 * If buffer is full, we have no choice but
		 * to drop the character
		 */
		if(fp->cnt != fp->bufsize){
			*fp->wp++ = c;
			if(fp->wp == &fp->buf[fp->bufsize])
				/* Wrap around */
				fp->wp = fp->buf;
			fp->cnt++;
		}
	}
}
/* Handle 8250 transmitter interrupts */
static
asytxint(dev)
unsigned dev;
{
	register struct dma *dp;
	register unsigned base;

	base = asy[dev].addr;
	dp = &asy[dev].dma;
	if(!dp->flags){
		/* "Shouldn't happen", but disable transmit
		 * interrupts anyway
		 */
		clrbit(base+IER,IER_TxE);
		return;	/* Nothing to send */
	}
	while(inportb(base+LSR) & LSR_THRE){
		outportb(base+THR,*dp->data++);
		if(--dp->cnt == 0){
			dp->flags = 0;
			/* Disable transmit interrupts */
			clrbit(base+IER,IER_TxE);
			/* Call completion interrupt here */
			break;
		}
	}
}
int
stxrdy(dev)
{
	return(!asy[dev].dma.flags);
}
/* Set bit(s) in I/O port */
setbit(port,bits)
unsigned port;
char bits;
{
	outportb(port,inportb(port)|bits);
}
/* Clear bit(s) in I/O port */
clrbit(port,bits)
unsigned port;
char bits;
{
	outportb(port,inportb(port) & ~bits);
}
/* Create a directory listing in a temp file and return the resulting file
 * descriptor. If full == 1, give a full listing; else return just a list
 * of names.
 *
 * This function is very dependent on the workings of Aztec standard I/O;
 * it uses their mechanism for generating and deleting temporary files.
 */
FILE *
dir(path,full)
char *path;
int full;
{
	FILE *fp;
	char cmd[50];
	char filename[13];		/* instance of filename */
	char name[L_tmpnam],*tmpnam(),*malloc();

	tmpnam(name);
	if(full){
		sprintf(cmd,"dir %s > %s",path,name);
		system(cmd);
	} else {
		fp = fopen(name,"w");
		filedir(path,0,filename);
		while(filename[0] != '\0'){
			fprintf(fp,"%s\n",filename);
			filedir(path,1,filename);
		}
		fclose(fp);
	}
	fp = fopen(name,"r");
	/* Set up the magic cookies inside the file structure so that the
	 * temporary file gets deleted later when the file is closed
	 */
	fp->_flags |= _TEMP;
	fp->_tmpname = malloc((unsigned)strlen(name)+1);
	strcpy(fp->_tmpname,name);
	return fp;

}
/* Network to host int32 */
int32
ntohl(x)
int32 x;
{
	register int32 ret;

	ret = ntohs(loword(x));
	ret <<= 16;
	ret |= ntohs(hiword(x));
	return ret;

}
/* Network to host short */
int16
ntohs(x)
int16 x;
{
	return (lobyte(x) << 8) | hibyte(x);
}	
bcmp(a,b,n)
register char *a,*b;
register int16 n;
{
	while(n-- != 0){
		if(*a++ != *b++)
			return 1;
	}
	return 0;
}
bzero(buf,cnt)
register char *buf;
register int16 cnt;
{
	while(cnt-- != 0)
		*buf++ = '\0';
}

int
asy_getspeed(dev)
int dev;
{
    if( dev >= nasy )
	return( 0 );
    else
	return( asy[dev].speed);
}


