#define	FTP_PORT	21	/* Control port */
#define	FTPD_PORT	20	/* Data port */
#define CTLZ	26		/* EOF for CP/M systems */

/* Per-session control block */
struct ftp {
	struct ftp *prev;	/* Linked list pointers */
	struct ftp *next;
	struct tcb *control;	/* TCP control connection */
	char state;
#define	START_STATE	0	/* New connection, haven't sent banner */
#define	COMMAND_STATE	1	/* Awaiting user command */
#define	SENDING_STATE	2	/* Sending data to user */
#define	RECEIVING_STATE	3	/* Storing data from user */

	char type;		/* Transfer type */
#define	IMAGE_TYPE	0
#define	ASCII_TYPE	1

	FILE *fp;		/* File descriptor being transferred */
	struct socket port;	/* Remote port for data connection */
	struct tcb *data;	/* Data connection */

	/* The following are used only by the server */
	char *username;		/* User's name */
	char *buf;		/* Input command buffer */
	char cnt;		/* Length of input buffer */
	char *cd;		/* Current directory name */

	/* And this is used only by the client */
	struct session *session;
};

#define	NULLFTP	(struct ftp *)NULL
