/* dirutil.c
 *	MS-Dos directory reading stuff.
 *	A.D. Barksdale Garbee II, aka Bdale, N3EUA
 *	Copyright 1986 Bdale Garbee, All Rights Reserved.
 *	Permission granted for non-commercial copying and use, provided
 *	this notice is retained.
 */

/*
   Based on an idea or two from Bob Hartman.
   Assumes Aztec C Compiler and libraries... very PC specific!
*/

#include <stat.h>
#define	NULLCHAR	((char *)0)

/* wildcard filename lookup */
filedir (name, times, ret_str)
char *name;
int times;
char *ret_str;
{
	char *cp;
	static struct {
		char rsvd[21];
		char attr;
		long ftime;
		long fsize;
		char fname[13];
	} 
	sbuf;

	bdos (0x1a, &sbuf);
	if(name == NULLCHAR || name[0] == '\0')
		name = "*.*";
	if (times == 0) {
		if (dos (0x4e, 0, ~ST_VLABEL, name, 0, 0) == -1) 
			sbuf.fname[0] = '\0';
		strcpy (ret_str, sbuf.fname);
	} else {
		if (dos (0x4f, 0, ~ST_VLABEL, name, 0, 0) == -1) 
			sbuf.fname[0] = '\0';
		strcpy (ret_str, sbuf.fname);
	}
	for(cp = ret_str; *cp != '\0'; cp++)	/* force to all lower case */
		*cp = tolower(*cp);
}
