/* Size of ARP hash table */
#define	ARPSIZE	17

/* Lifetime of a valid ARP entry (seconds) */
#define	ARPLIFE		(15*60)	/* 15 minutes */
/* Lifetime of a pending ARP entry (seconds) */
#define	PENDTIME	15	/* 15 seconds */

/* ARP definitions (see RFC 826) */

/* Address size definitions */
#define	IPALEN	4		/* Length in bytes of an IP address */
#define	MAXHWALEN	256	/* Maximum length of a hardware address */

/* ARP opcodes */
#define	ARP_REQUEST	1
#define	ARP_REPLY	2

/* Hardware types */
#define	ARP_ETHER	1	/* Assigned to 10 megabit Ethernet */
#define	ARP_EETHER	2	/* Assigned to experimental Ethernet */
#define	ARP_AX25	3	/* Assigned to AX.25 Level 2 */
#define	ARP_PRONET	4	/* Assigned to PROnet token ring */
#define	ARP_CHAOS	5	/* Assigned to Chaosnet */

/* Table of hardware types known to ARP */
struct arp_type {
	int hwalen;		/* Hardware length */
	int iptype;		/* Hardware type field for IP */
	int arptype;		/* Hardware type field for ARP */
	char *bdcst;		/* Hardware broadcast address */
};
extern struct arp_type arp_type[];

/* Format of an ARP request or reply packet. From p. 3 */
struct arp {
	int16 hardware;			/* Hardware type */
	int16 protocol;			/* Protocol type */
	char hwalen;			/* Hardware address length, bytes */
	char pralen;			/* Length of protocol address */
	int16 opcode;			/* ARP opcode (request/reply) */
	char shwaddr[MAXHWALEN];	/* Sender hardware address field */
	int32 sprotaddr;		/* Sender Protocol address field */
	char thwaddr[MAXHWALEN];	/* Target hardware address field */
	int32 tprotaddr;		/* Target protocol address field */
};
		
/* Format of ARP table */
struct arp_tab {
	struct arp_tab *next;	/* Doubly-linked list pointers */
	struct arp_tab *prev;	
	int32 ip_addr;		/* IP Address, host order */
	int16 hardware;		/* Hardware type */
	char *hw_addr;		/* Hardware address */
	char state;		/* (In)complete */
#define	ARP_PENDING	0
#define	ARP_VALID	1
	struct timer timer;	/* Time until aging this entry */
	struct mbuf *pending;	/* Queue of datagrams awaiting resolution */
};
#define	NULLARP	(struct arp_tab *)NULL
extern struct arp_tab *arp_tab[];

struct arp_stat {
	int recv;	/* Total number of ARP packets received */
	int badtype;	/* Incoming requests for unsupported hardware */
	int badlen;	/* Incoming length field(s) didn't match types */
	int inreq;	/* Incoming requests for us */
	int replies;	/* Replies sent */
	int outreq;	/* Outoging requests sent */
};
