|
|	SoftWare Character Generator for VGA display card
|							Auther:takamiti@mix
#include <minix/config.h>
#include "vga.h"

#define CH_High	 8
#define TOP_OFS	12

|*============================================================================*
|*				text
|*============================================================================*
		.text

.define	_draw_ank
.define	_draw_dbc
.define	_scr_up
.define	_scr_down
.define	_clr_scr
.define	_clr_line
.define	_cur_off
.define	_cur_on
.define _mov_left
.define _mov_right
#if (LANGUAGE == JAPANESE)
|.define	_ms2index
|.define _jis2index
.define _ms2jis
#endif

|	ax = Y-axis	->	bx = &scr_buf[x][y]
|	di = X-axis		di = pixel address
pixeladdr:	add	ax,vid_Ytop
		cmp	ax,#SCR_LINES
		jc	pxaddr
		sub	ax,#SCR_LINES
pxaddr:		mov	bx,ax
		movb	cl,*LINE_WIDTH
		mulb	cl
		add	ax,di
		add	ax,#_scr_buf		| scr_buf[x][y]
		xchg	ax,bx
		mov	cx,#CHAR_PER_LINE
		mul	cx
		add	di,ax			| pixel address
		ret

|	pixel_addr(x, y)
_pixel_addr:	push	bp
		mov	bp,sp
		push	di
		mov	di,4(bp)
		mov	ax,6(bp)
		call	pixeladdr
		mov	vid_ptr,di
		mov	img_ptr,bx
		mov	ax,di
		pop	di
		pop	bp
		ret

#if (LANGUAGE == JAPANESE)
_ms2jis:	push	bp
		mov	bp,sp
		mov	ax,4(bp)
		shlb	ah,*1
		cmpb	al,*0x80
		adc	ax,#0x1F61
		addb	al,*0x7F
		jc	ms2j
		addb	al,*0x0A2
ms2j:		andb	ah,*0x07F
		pop	bp
		ret
#endif

|	draw_ank(attr, char)
_draw_ank:	push	bp
		mov	bp,sp
		push	es
		push	di
		push	si

		mov	di,vid_ptr
		cmp	di,#LAST_COLUMN
		ja	draw_exit
		mov	si,#_ankfont
		mov	ax,6(bp)	| char
		xorb	ah,ah
		shl	ax,*1
		shl	ax,*1
		shl	ax,*1
		shl	ax,*1		| *16
		add	si,ax
		mov	ax,_VIDEO_SEG
		mov	es,ax

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0F01
		outw
		mov	ax,#0x0003
		outw
		mov	ax,4(bp)	| attr
		xorb	al,al
		outw

		mov	cx,#CHAR_HIGH
		push	cx
		mov	ax,#0xff08
d_ank0:		outw
		seg	es
		orb	(di),al
		add	di,#BYTE_PER_LINE
		loop	d_ank0
		pop	cx

		mov	di,vid_ptr
		movb	ah,4(bp)
		xorb	al,al
		outw
		movb	al,*0x08
d_ank1:		movb	ah,(si)
		outw
		seg	es
		orb	(di),al
		inc	si
		add	di,#BYTE_PER_LINE
		loop	d_ank1

		test	_disp_stat,#UNDER_LINE_BIT
		jz	d_ank2
		sub	di,#BYTE_PER_LINE
		movb	ah,*0xff
		outw
		seg	es
		orb	(di),al
d_ank2:
		mov	bx,img_ptr
		movb	al,4(bp)
		movb	(bx),al
		mov	ax,#1

def_mode:	add	bx,ax
		cmp	bx,#_scr_buf + SCRBUF_SIZE
		jae	overrun
		mov	img_ptr,bx
		add	vid_ptr,ax
overrun:
		xor	ax,ax
		outw
		inc	ax
		outw
		movb	al,*0x03
		outw
		mov	ax,#0xff08
		outw
draw_exit:
		pop	si
		pop	di
		pop	es
		pop	bp
		ret


|	draw_dbc(attr, &sysfont_tbl[?])
_draw_dbc:	push	bp
		mov	bp,sp
		push	es
		push	di
		push	si

		mov	di,vid_ptr
		cmp	di,#LAST_COLUMN - 1
		ja	draw_exit
		mov	ax,_VIDEO_SEG
		mov	es,ax

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0f01
		outw
		mov	ax,#0x0003
		outw

		mov	cx,#CHAR_HIGH
		mov	ax,4(bp)		| attr
		xorb	al,al
		outw
		mov	ax,#0xff08
d_dbc0:		outw
		seg	es
		orb	(di),al
		inc	di
|		outw
		seg	es
		orb	(di),al
		add	di,#BYTE_PER_LINE - 1
		loop	d_dbc0

		mov	di,vid_ptr
		mov	bx,6(bp)
		add	di,TOP_OFS(bx)
		mov	cx,CH_High(bx)
		mov	si,#_fontbuf
		movb	ah,4(bp)
		xorb	al,al
		outw
		movb	al,*0x08
d_dbc1:		movb	ah,(si)
		outw
		seg	es
		orb	(di),al
		inc	si
		movb	ah,(si)
		outw
		inc	di
		seg	es
		orb	(di),al
		add	di,#BYTE_PER_LINE - 1
		inc	si
		loop	d_dbc1

		test	_disp_stat,#UNDER_LINE_BIT
		jz	d_dbc2
		sub	di,#BYTE_PER_LINE
		movb	ah,*0xff
		outw
		seg	es
		orb	(di),al
|		outw
		inc	di
		seg	es
		orb	(di),al
d_dbc2:
		mov	bx,img_ptr
		mov	ax,4(bp)
		movb	ah,al
		orb	al,*0x80
		mov	(bx),ax
		mov	ax,#2
		jmp	def_mode


|		scr_down()
_scr_down:	cmp	_softscroll,#0
		jz	hw_scrdwn
		jmp	mov_down

hw_scrdwn:	mov	ax,vid_Ytop
		dec	ax
		jns	do_scroll
		mov	ax,#SCR_LINES - 1
		j	do_scroll

|		scr_up()
_scr_up:	cmp	_softscroll,#0
		jz	hw_scrup
		jmp	mov_up

hw_scrup:	mov	ax,vid_Ytop
		inc	ax
		cmp	ax,#SCR_LINES
		jc	do_scroll
		xor	ax,ax

do_scroll:	mov	vid_Ytop,ax
		mov	cx,#CHAR_PER_LINE
		mul	cx
		mov	bx,ax

		mov	dx,#CRT_CTRL_REG
		movb	al,*0x0C
		outw

		movb	ah,bl
		movb	al,*0x0D
		outw

		mov	dx,#CRT_STAT_REG
L_00A:		in
		testb	al,*0x08
		jz	L_00A

		mov	ax,#SCR_LINES
		sub	ax,vid_Ytop
		shl	ax,*1			| movb	cl,*CHAR_HIGH
		shl	ax,*1			| mulb	cl
		shl	ax,*1
		shl	ax,*1
		dec	ax

		movb	bh,ah
		movb	bl,bh
		and	bx,#0x0201
		shl	bx,*1
		shl	bx,*1
		shl	bx,*1
		shl	bx,*1
		shlb	bh,*1

		mov	dx,#CRT_CTRL_REG
		movb	ah,al
		movb	al,*0x18
		outw

		movb	al,*7
		out
		inc	dx
		in
		dec	dx

		movb	ah,al
		andb	ah,*0xEF
		orb	ah,bl

		movb	al,*7
		outw
		movb	al,*9
		out
		inc	dx
		in
		dec	dx

		movb	ah,al
		andb	ah,*0xBF
		orb	ah,bh
		movb	al,*9
		outw
		ret


|		clr_scr()
_clr_scr:	push	es
		push	di

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0005
		outw
		xor	ax,ax
		outw
		mov	ax,#0x0F01
		outw

		mov	ax,_VIDEO_SEG
		mov	es,ax
		xor	di,di
		mov	cx,#PLANE_SIZE
		xor	ax,ax
		cld
		rep
		stob
		mov	ax,ds
		mov	es,ax
		mov	di,#_scr_buf
		mov	cx,#SCRBUF_SIZE
		movb	al,*BLANK_FG_COLOR
		rep
		stob
		pop	di
		pop	es
		xor	ax,ax
		jmp	do_scroll


|		clr_line(x, y, length)
_clr_line:	push	bp
		mov	bp,sp
		push	es
		push	di
		mov	di,4(bp)	| x
		mov	ax,6(bp)	| y
		call	pixeladdr

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0005
		outw
		xor	ax,ax
		outw
		mov	ax,#0x0F01
		outw

		mov	ax,_VIDEO_SEG
		mov	es,ax
		mov	cx,#CHAR_HIGH
		xor	ax,ax
		cld
clr_l0:		push	cx
		push	di
		mov	cx,8(bp)	| length
		rep
		stob
		pop	di
		add	di,#BYTE_PER_LINE
		pop	cx
		loop	clr_l0
|		mov	ax,#0x0001
|		outw

		mov	di,bx
		push	ds
		pop	es
		mov	cx,8(bp)
		movb	al,*BLANK_FG_COLOR
		rep
		stob

		pop	di
		pop	es
		pop	bp
		ret


|		cur_off()
_cur_off:	push	bp
		push	es
		push	di
		mov	di,cur_addr
		movb	bl,cur_attr
		jmp	cur_comm

|		cur_on(x, y)|
_cur_on:	push	bp
		mov	bp,sp
		push	es
		push	di
		mov	di,4(bp)		| X
		mov	ax,6(bp)		| Y
		call	pixeladdr
		mov	cur_addr,di		| save cursor address
		movb	bl,(bx)			| screen image
		movb	cur_attr,bl

cur_comm:	mov	ax,_VIDEO_SEG
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0A05
		outw
		mov	ax,#0x1803
		outw
		mov	ax,#0x0007
		outw
		mov	ax,#0xff08
		movb	bh,bl
		andb	bh,*0x7f
		mov	cx,#CHAR_HIGH
		push	di
putcur01:	outw
		seg	es
		orb	(di),bh
		add	di,#BYTE_PER_LINE
		loop	putcur01
		pop	di
		testb	bl,*0x80
		jz	putcur03
		mov	cx,#CHAR_HIGH
		inc	di
putcur02:	outw
		seg	es
		orb	(di),bh
		add	di,#BYTE_PER_LINE
		loop	putcur02
putcur03:	mov	ax,#0xff08
		outw
		mov	ax,#0x0005
		outw
		mov	ax,#0x0003
		outw
		mov	ax,#0x0f07
		outw
		pop	di
		pop	es
		pop	bp
		ret

|		mov_right(src_x, src_y, dect_x, dest_y, length)
_mov_right:	std
		j	mv_blok

|		mov_left(src_x, src_y, dect_x, dest_y, length)
_mov_left:	cld
mv_blok:	push	bp
		mov	bp,sp
		push	si
		push	di
		push	es
		push	ds
		mov	di,4(bp)	| src-X
		mov	ax,6(bp)	| src-Y
		call	pixeladdr
		mov	si,di
		push	bx
		mov	di,8(bp)	| dest-X
		mov	ax,10(bp)	| dest-Y
		call	pixeladdr
		push	bx

		mov	ax,_VIDEO_SEG
		mov	ds,ax
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0105
		outw

		movb	al,*CHAR_HIGH - 1
mv_loop:	mov	cx,12(bp)
		push	si
		push	di
		rep
		movb
		pop	di
		pop	si
		add	di,*BYTE_PER_LINE
		add	si,*BYTE_PER_LINE
		decb	al
		jns	mv_loop
|		mov	ax,0005h
|		out	dx,ax

		pop	di
		pop	si
		pop	ds
		mov	ax,ds
		mov	es,ax
		mov	cx,12(bp)
		rep
		movb
		pop	es
		pop	di
		pop	si
		pop	bp
		ret


|		mov_down()
mov_down:	push	si
		push	di
		push	es
		push	ds

		std
		mov	di,#PLANE_SIZE - 1
		mov	si,#PLANE_SIZE - CHAR_PER_LINE - 1
		mov	cx,si

		mov	ax,#_scr_buf + SCRBUF_SIZE - 1
		push	ax
		mov	ax,#_scr_buf + SCRBUF_SIZE - LINE_WIDTH - 1
		push	ax
		push	ax
		j	mv_scr

|		mov_up()
mov_up:		push	si
		push	di
		push	es
		push	ds

		cld
		xor	di,di
		mov	si,#CHAR_PER_LINE
		mov	cx,#PLANE_SIZE - CHAR_PER_LINE
		mov	ax,#_scr_buf
		push	ax
		add	ax,#LINE_WIDTH
		push	ax
		mov	ax,#SCRBUF_SIZE - LINE_WIDTH
		push	ax
mv_scr:
		mov	ax,_VIDEO_SEG
		mov	ds,ax
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0105
		outw
		rep
		movb
		pop	cx
		pop	si
		pop	di

		pop	ds
		mov	ax,ds
		mov	es,ax
		rep
		movb

		pop	es
		pop	di
		pop	si
		ret

#ifdef GRAPHICS
.define	_gr_dot

|		void gr_dot(int x, int y, int attr)
_gr_dot:	push	bp
		mov	bp,sp
		mov	ax,vid_Ytop
		shl	ax,*1
		shl	ax,*1
		shl	ax,*1
		shl	ax,*1			| vid_Ytop * CHAR_HIGH
		mov	cx,#MAX_SCAN_LINE
		sub	cx,6(bp)		| Y
		add	ax,cx
		cmp	ax,#MAX_SCAN_LINE
		jle	dot_1
		sub	ax,#MAX_SCAN_LINE
dot_1:
		mov	dx,#BYTE_PER_LINE
		mul	dx
		mov	bx,4(bp)		| X
		mov	cx,bx
		shr	bx,*1
		shr	bx,*1
		shr	bx,*1
		add	bx,ax
		cmp	bx,#GR_BUFF_LEN
		jnc	dot_exit

		andb	cl,*0x07
		xorb	cl,*0x07
		movb	ch,*0x01
		shlb	ch,cl
		push	es
		mov	ax,_VIDEO_SEG
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0205
		outw
		movb	ah,ch
		movb	al,*0x08
		outw
		seg	es
		movb	al,(bx)
		mov	ax,8(bp)		| color
		seg	es
		movb	(bx),al
		mov	ax,#0x0003
		outw
		mov	ax,#0xff08
		outw
		pop	es
dot_exit:	pop	bp
		ret
#endif


|*============================================================================*
|*				data
|*============================================================================*
		.data

.define		_VIDEO_SEG
.define		_sys_font
.define		_scr_buf
.extern		_ankfont
.extern		_fontbuf
.extern		_disp_stat
.extern		_softscroll

| local value
cur_addr:	.word	0
cur_attr:	.word	0
vid_Ytop:	.word	0
vid_ptr:	.word	0
img_ptr:	.word	0

_VIDEO_SEG:	.word	0xA000
_scr_buf:	.zerow	SCRBUF_SIZE / 2
_sys_font:
rom_ank:				| sys_font[0]
		.long	0		| long ft_base
		.word	0		| short ft_limit
		.word	0		| short fn_size
		.word	0		| short fn_high
		.word	0		| short fn_width
		.word	0		| short top_margin
		.word	0		| short flag

usr_ank:	.zerow	8		| sys_font[1]
dbcs_1font:	.zerow	8		| sys_font[2]
dbcs_2font:	.zerow	8		| sys_font[3]

| end fo SCG.X
