.TH xwafecf 1
.SH NAME
.PP
xwafecf \- an X-based card filer 

.ad
.SH SYNOPSIS
.PP
\f3xwafecf\f1 [\f3-c \f2colormode\f1] 
[\f3-3\f1] 
[\f3-a\f2 name of application\f1] 
[\f3-s\f2 sourcefile\f1] 

.SH DESCRIPTION
.PP
Xwafecf processes a file  containing several units of data, which all
have the same structure. Xwafecf can be used to consecutively view
each record or to perform a simple search operation. The program can
easily be extended to work with new types of records.

.SH OPTIONS
.PP
In addition to the standard toolkit options 
such as -display, -name, -geometry, -iconic, -xrm etc. (see manual
page X) xwafenews accepts the following options:
.TP
\f3-c \f2colormode\f1
start xwafenews using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-3\f1
do not use 3 dimensional widgets. This option depends of the configuration 
in the system.waferc file (see manual page wafeapp).

.TP
\f3-a \f2 application name\f1
Used to specify the data record's structure.  If \fIbib\fP is
specified, the data records are supposed to have our bibligraphic
database file format, if \fIpasswd\fP is passed, standard UNIX passwd
file structure is assumed and if the option \fIgroup\fP is specified
the structure of the /etc/groups file's entries will be used. The
default value is \fIbib\fP.


.TP
\f3-s \f2 source file
Use this option to specify the database file. Reasonable default values
were provided for each application option. 

.SH "LAYOUT and INTERACTION" 

Keyboard input focus is always set on the small text field at the
bottom of the application's window. This text widget is used to enter a
search string, which will be matched against every field in all
records. The search is started by pressing the Return Key, the total
number of all found records as well as the current record is shown.
With the <Prev> and <Next> buttons all found records can be viewed.
<Quit> terminates the application. 

.SH "KEY BINDINGS"
.TP 13
<Key>Up
read previous record
.TP
<Key>Down
read next record
.TP
<Key>Prior
read previous record
.TP
<Key>Next
next next recvord
.TP
<key>Return
start search

.SH EXPANSIBILITY

All relevant informations concerning the structure of a single record
(number and name of a field, delimiters) and the default filename are
kept in Perl arrays at the beginning of the program. Therefore, xwafecf
can easily be enhanced to support additional types od database files.

.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$wafecfSearchPath 
default load path for application data
.TP
$boldFont
used for all fixed labels
.TP
$normalFont
used to display the current resord
.TP
$background
background color
.TP
$buttonColors
foreground and background colors of all buttons, depending on specified
color option.

.SH FILES 
.PP
.EX 0
$WAFELIB/system.waferc
$WAFELIB/bib-sample.db
$HOME/.waferc
/etc/passwd
/etc/group
.EE

.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
    Wirtschaftsuniversitaet Wien, 
    Abteilung fuer Wirtschaftsinformatik
    Augasse 2-6, 
    A-1090 Vienna, Austria
    neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
