'\"
'\" Generated from ../tcllib/modules/csv/csv.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "csv" n 0.3 csv "CSV processing"
.BS
.SH NAME
csv \- Procedures to handle CSV data.
.SH "SYNOPSIS"
package require \fBTcl 8.3\fR
.sp
package require \fBcsv ?0.3?\fR
.sp
\fB::csv::join\fR \fIvalues\fR {\fIsepChar\fR ,}\fR
.sp
\fB::csv::joinlist\fR \fIvalues\fR {\fIsepChar\fR ,}\fR
.sp
\fB::csv::read2matrix\fR \fIchan m\fR {\fIsepChar\fR ,} {\fIexpand\fR none}\fR
.sp
\fB::csv::read2queue\fR \fIchan q\fR {\fIsepChar\fR ,}\fR
.sp
\fB::csv::report\fR \fIcmd matrix\fR ?\fIchan\fR?\fR
.sp
\fB::csv::split\fR \fIline\fR {\fIsepChar\fR ,}\fR
.sp
\fB::csv::split2matrix\fR \fIm line\fR {\fIsepChar\fR ,} {\fIexpand\fR none}\fR
.sp
\fB::csv::split2queue\fR \fIq line\fR {\fIsepChar\fR ,}\fR
.sp
\fB::csv::writematrix\fR \fIm chan\fR {\fIsepChar\fR ,}\fR
.sp
\fB::csv::writequeue\fR \fIq chan\fR {\fIsepChar\fR ,}\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBcsv\fR package provides commands to manipulate information
in CSV \fBFORMAT\fR (CSV = Comma Separated Values).
.SH "COMMANDS"
.PP
The following commands are available:
.TP
\fB::csv::join\fR \fIvalues\fR {\fIsepChar\fR ,}\fR
Takes a list of values and returns a string in CSV format containing
these values. The separator character can be defined by the caller,
but this is optional. The default is ",".
.TP
\fB::csv::joinlist\fR \fIvalues\fR {\fIsepChar\fR ,}\fR
Takes a list of lists of values and returns a string in CSV format
containing these values. The separator character can be defined by the
caller, but this is optional. The default is ",". Each element of the
outer list is considered a record, these are separated by newlines in
the result. The elements of each record are formatted as usual (via
\fB::csv::join\fR).
.TP
\fB::csv::read2matrix\fR \fIchan m\fR {\fIsepChar\fR ,} {\fIexpand\fR none}\fR
A wrapper around \fB::csv::split2matrix\fR (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given matrix. For an explanation of the \fIexpand\fR
argument see \fB::csv::split2matrix\fR.
.TP
\fB::csv::read2queue\fR \fIchan q\fR {\fIsepChar\fR ,}\fR
A wrapper around \fB::csv::split2queue\fR (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given queue.
.TP
\fB::csv::report\fR \fIcmd matrix\fR ?\fIchan\fR?\fR
A report command which can be used by the matrix methods
\fBformat 2string\fR and \fBformat 2chan\fR. For the latter this
command delegates the work to \fB::csv::writematrix\fR. \fIcmd\fR is
expected to be either \fBprintmatrix\fR or
\fBprintmatrix2channel\fR. The channel argument, \fIchan\fR, has
to be present for the latter and must not be present for the first.
.TP
\fB::csv::split\fR \fIline\fR {\fIsepChar\fR ,}\fR
converts a \fIline\fR in CSV format into a list of the values
contained in the line. The character used to separate the values from
each other can be defined by the caller, via \fIsepChar\fR, but this
is optional. The default is ",".
.TP
\fB::csv::split2matrix\fR \fIm line\fR {\fIsepChar\fR ,} {\fIexpand\fR none}\fR
The same as \fB::csv::split\fR, but appends the resulting list as a
new row to the matrix \fIm\fR, using the method \fBadd row\fR. The
expansion mode specified via \fIexpand\fR determines how the command
handles a matrix with less columns than contained in \fIline\fR. The
allowed modes are:
.RS
.TP
\fBnone\fR
This is the default mode. In this mode it is the responsibility of the
caller to ensure that the matrix has enough columns to contain the
full line. If there are not enough columns the list of values is
silently truncated at the end to fit.
.TP
\fBempty\fR
In this mode the command expands an empty matrix to hold all columns
of the specified line, but goes no further. The overall effect is that
the first of a series of lines determines the number of columns in the
matrix and all following lines are truncated to that size, as if mode
\fBnone\fR was set.
.TP
\fBauto\fR
In this mode the command expands the matrix as needed to hold all
columns contained in \fIline\fR. The overall effect is that after
adding a series of lines the matrix will have enough columns to hold
all columns of the longest line encountered so far.
.RE
.TP
\fB::csv::split2queue\fR \fIq line\fR {\fIsepChar\fR ,}\fR
The same as \fB::csv::split\fR, but appending the resulting list as a
single item to the queue \fIq\fR, using the method \fBput\fR.
.TP
\fB::csv::writematrix\fR \fIm chan\fR {\fIsepChar\fR ,}\fR
A wrapper around \fB::csv::join\fR taking all rows in the matrix
\fIm\fR and writing them CSV formatted into the channel \fIchan\fR.
.TP
\fB::csv::writequeue\fR \fIq chan\fR {\fIsepChar\fR ,}\fR
A wrapper around \fB::csv::join\fR taking all items in the queue
\fIq\fR (assumes that they are lists) and writing them CSV formatted
into the channel \fIchan\fR.
.SH "FORMAT"
.PP
Each record of a csv file (comma-separated values, as exported e.g. by
Excel) is a set of ASCII values separated by ",". For other languages
it may be ";" however, although this is not important for this case
(The functions provided here allow any separator character).
.PP
If a value contains itself the separator ",", then it (the value) is
put between "".
.PP
If a value contains ", it is replaced by "".
.SH "EXAMPLE"
The record
.PP
.nf
123,"123,521.2","Mary says ""Hello, I am Mary"""
.fi
.PP
is parsed as follows:
.PP
.nf
a) 123
b) 123,521.2
c) Mary says "Hello, I am Mary"
.fi
.SH "SEE ALSO"
matrix, queue
.SH "KEYWORDS"
csv, matrix, queue, package, tcllib
