'\"
'\" Generated from ../tcllib/modules/cmdline/cmdline.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "cmdline" n 1.2 cmdline "command line / option processing"
.BS
.SH NAME
cmdline \- Procedures to process command lines and options.
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBcmdline ?1.2?\fR
.sp
\fB::cmdline::getopt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR\fR
.sp
\fB::cmdline::getKnownOpt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR\fR
.sp
\fB::cmdline::getoptions\fR \fIarglistVar\fR \fIoptlist\fR ?\fIusage\fR?\fR
.sp
\fB::cmdline::getKnownOptions\fR \fIarglistVar\fR \fIoptlist\fR ?\fIusage\fR?\fR
.sp
\fB::cmdline::usage\fR \fIoptlist\fR ?\fIusage\fR?\fR
.sp
\fB::cmdline::getfiles\fR \fIpatterns\fR \fIquiet\fR\fR
.sp
\fB::cmdline::getArgv0\fR \fR
.sp
.BE
.SH "DESCRIPTION"
This package provides commands to parse command lines and options.
.TP
\fB::cmdline::getopt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR\fR
This command works in a fashion like the standard C based \fBgetopt\fR
function.  Given an option string and a pointer to an array or args
this command will process the first argument and return info on how to
procede. The command returns 1 if an option was found, 0 if no more
options were found, and -1 if an error occurred.
.sp
\fIargvVar\fR contains the name of the argv list to process. If
options are found the arg list is modified and the processed arguments
are removed from the start of the list.
.sp
\fIoptstring\fR contains a list of command options that the
application will accept.  If the option ends in ".arg" the command
will use the next argument as an argument to the option.  Otherwise
the option is a boolean that is set to 1 if present.
.sp
\fIoptVar\fR refers to the variable the command will store the found
option into (without the leading '-' and without the .arg extension).
.sp
\fIvalVar\fR refers to the variable to store either the value for the
specified option into upon success or an error message in the case of
failure. The stored value comes from the command line for .arg
options, otherwise the value is 1.
.TP
\fB::cmdline::getKnownOpt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR\fR
Like \fB::cmdline::getopt\fR, but ignores any unknown options in the
input.
.TP
\fB::cmdline::getoptions\fR \fIarglistVar\fR \fIoptlist\fR ?\fIusage\fR?\fR
Processes the set of command line options found in the list variable
named by \fIarglistVar\fR and fills in defaults for those not
specified.  This also generates an error message that lists the
allowed flags if an incorrect flag is specified. The optional
\fIusage\fR-argument contains a string to include in front of the
generated message. If not present it defaults to "options:".
.sp
\fIoptlist\fR contains a list of lists where each element specifies an
option in the form: \fIflag\fR \fIdefault\fR \fIcomment\fR.
.sp
If \fIflag\fR ends in ".arg" then the value is taken from the command
line. Otherwise it is a boolean and appears in the result if present
on the command line. If \fIflag\fR ends in ".secret", it will not be
displayed in the usage.
.TP
\fB::cmdline::getKnownOptions\fR \fIarglistVar\fR \fIoptlist\fR ?\fIusage\fR?\fR
Like \fB::cmdline::getoptions\fR, but ignores any unknown options in the
input.
.TP
\fB::cmdline::usage\fR \fIoptlist\fR ?\fIusage\fR?\fR
Generates and returns an error message that lists the allowed
flags. \fIoptlist\fR is defined as for
\fB::cmdline::getoptions\fR. The optional \fIusage\fR-argument
contains a string to include in front of the generated message. If not
present it defaults to "options:".
.TP
\fB::cmdline::getfiles\fR \fIpatterns\fR \fIquiet\fR\fR
Given a list of file \fIpatterns\fR this command computes the set of
valid files.  On windows, file globbing is performed on each argument.
On Unix, only file existence is tested.  If a file argument produces
no valid files, a warning is optionally generated (set \fIquiet\fR to
true).
.sp
This code also uses the full path for each file.  If not given it
prepends the current working directory to the filename. This ensures
that these files will never conflict with files in a wrapped zip
file. The last sentence refers to the pro-tools.
.TP
\fB::cmdline::getArgv0\fR \fR
This command returns the "sanitized" version of \fIargv0\fR.  It will
strip off the leading path and removes the ".bin" extensions that the
pro-apps use because they must be wrapped by a shell script.
.SH "KEYWORDS"
cmdline processing

