'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: bgerror.n,v 1.2.18.3 2001/10/09 19:04:01 hobbs Exp $
'\" 
.so man.macros
.TH bgerror n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
bgerror \- Command invoked to process background errors
.SH SYNOPSIS
\fBbgerror \fImessage\fR
.BE

.SH DESCRIPTION
.PP
The \fBbgerror\fR command doesn't exist as built-in part of Tcl.  Instead,
individual applications or users can define a \fBbgerror\fR
command (e.g. as a Tcl procedure) if they wish to handle background
errors.
.PP
A background error is one that occurs in an event handler or some
other command that didn't originate with the application.
For example, if an error occurs while executing a command specified
with the \fBafter\fR command, then it is a background error.
For a non-background error, the error can simply be returned up
through nested Tcl command evaluations until it reaches the top-level
code in the application; then the application can report the error
in whatever way it wishes.  When a background error occurs, the
unwinding ends in the Tcl library and there is no obvious way for Tcl
to report the error.
.PP
When Tcl detects a background error, it saves information about the
error and invokes the \fBbgerror\fR command later as an idle event
handler. Before invoking \fBbgerror\fR, Tcl restores the
\fBerrorInfo\fR and \fBerrorCode\fR variables to their values at the
time the error occurred, then it invokes \fBbgerror\fR with the error
message as its only argument.  Tcl assumes that the application has
implemented the \fBbgerror\fR command, and that the command will
report the error in a way that makes sense for the application.  Tcl
will ignore any result returned by the \fBbgerror\fR command as long
as no error is generated.
.PP
If another Tcl error occurs within the \fBbgerror\fR command (for
example, because no \fBbgerror\fR command has been defined) then Tcl
reports the error itself by writing a message to stderr.
.PP
If several background errors accumulate before \fBbgerror\fR is
invoked to process them, \fBbgerror\fR will be invoked once for each
error, in the order they occurred.  However, if \fBbgerror\fR returns
with a break exception, then any remaining errors are skipped without
calling \fBbgerror\fR.
.PP
Tcl has no default implementation for \fBbgerror\fR. However, in
applications using Tk there is a default \fBbgerror\fR procedure which
posts a dialog box containing the error message and offers the user a
chance to see a stack trace showing where the error occurred.  In
addition to allowing the user to view the stack trace, the dialog
provides an additional application configurable button which may be
used, for example, to save the stack trace to a file.  By default,
this is the behavior associated with that button.  This behavior can
be redefined by setting the option database values
\fB*ErrorDialog.function.text\fR, to specify the caption for the
function button, and \fB*ErrorDialog.function.command\fR, to specify
the command to be run.  The text of the stack trace is appended to the
command when it is evaluated.  If either of these options is set to
the empty string, then the additional button will not be displayed in
the dialog.

.SH "SEE ALSO"
after(n), tclvars(n)

.SH KEYWORDS
background error, reporting
