/*
tclsql.c -- Release 3.1
(No Changes from 2.1 in this file at all !)
sql commands for informix database support
*/

#ifndef lint
static char rcsid[] = "$Header: /u/kumar/:w/RCS/tclsql.c,v 2.1 1993/06/17 17:41:50 kumar Exp kumar $ SPRITE (Berkeley)";
#endif

#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "tcl.h"

int tcl_informix_cmds();
int tcl_system();
extern char *sql_geterror();
isql_init(interp) Tcl_Interp *interp; {
    Tcl_CreateCommand(interp, "sql", tcl_informix_cmds, 
        (ClientData)0L,(void (*)()) NULL);
    Tcl_CreateCommand(interp, "tcl_system", tcl_system, 
        (ClientData)0L,(void (*)()) NULL);
    return TCL_OK;
}

static int tcl_sql_usage(interp) Tcl_Interp *interp; {
    Tcl_AppendResult(interp, "wrong args to sql: should be one of open,\n\
        fetch,close,run,exists,reopen,explain,geterror,sqlca,sqlda,\n\
        sqld,database,getdatabase,finish,connect,disconnect,setconnection,\n\
		readblob,writeblob,begin,commit,rollback\n",
		(char *)NULL);
    return TCL_ERROR;
}

int tcl_informix_cmds(dummy, interp, argc, argv) 
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *minor = argv[1];
    int mlen;

    if (!minor) return tcl_sql_usage(interp);
    mlen = strlen(minor);
	if (*minor == 'b')
        return tcl_sql_begin_work(dummy, interp, --argc, ++argv);
    if (*minor == 'c') {
		if (mlen < 2) mlen = 2;
		if (strncmp(minor, "close", mlen) == 0)
        	return tcl_sql_close(dummy, interp, --argc, ++argv);
		mlen = 3;
		if (strncmp(minor, "connect", mlen) == 0)
        	return tcl_sql_connect(dummy, interp, --argc, ++argv);
		if (strncmp(minor, "commit", mlen) == 0)
        	return tcl_sql_commit(dummy, interp, --argc, ++argv);
		mlen = 4;
		if (strncmp(minor, "colnames", mlen) == 0)
			return tcl_sql_sqlcols(dummy, interp, --argc, ++argv);
		if (strncmp(minor, "coltypes", mlen) == 0)
			return tcl_sql_sqlcols(dummy, interp, --argc, ++argv);
		if (strncmp(minor, "colcharlen", mlen) == 0)
			return tcl_sql_sqlcols(dummy, interp, --argc, ++argv);
		if (strncmp(minor, "coldblen", mlen) == 0)
			return tcl_sql_sqlcols(dummy, interp, --argc, ++argv);
        return tcl_sql_usage(interp);
	}
    if (*minor == 'd') {
		if (mlen < 2) mlen = 2;
		if (strncmp(minor, "database", mlen) == 0)
        	return tcl_sql_database(dummy, interp, --argc, ++argv);
		if (strncmp(minor, "disconnect", mlen) == 0)
        	return tcl_sql_disconnect(dummy, interp, --argc, ++argv);
	}
    if (*minor == 'e') {
        if (mlen < 3) mlen = 3;
        if (strncmp(minor, "exists", mlen) == 0)
            return tcl_sql_exists(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "explain", mlen) == 0)
            return tcl_sql_explain(dummy, interp, --argc, ++argv);
        return tcl_sql_usage(interp);
    }
    if (*minor == 'f') {
        if (mlen < 2) mlen = 2;
        if (strncmp(minor, "fetch", mlen) == 0)
            return tcl_sql_fetch(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "finish", mlen) == 0)
            return tcl_sql_finish(dummy, interp, --argc, ++argv);
        return tcl_sql_usage(interp);
    }
    if (*minor == 'g') {
        if (mlen < 4) mlen = 4;
        if (strncmp(minor, "geterror", mlen) == 0)
            return tcl_sql_geterror(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "getdatabase", mlen) == 0)
            return tcl_sql_getdatabase(dummy, interp, --argc, ++argv);
        return tcl_sql_usage(interp);
    }
    if (*minor == 'o' && strncmp(minor, "open", mlen) == 0)
        return tcl_sql_open(dummy, interp, --argc, ++argv);
    if (*minor == 'r') {
        if (mlen < 2) mlen = 2;
        if (strncmp(minor, "run", mlen) == 0)
            return tcl_sql_run(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "rollback", mlen) == 0)
            return tcl_sql_rollback(dummy, interp, --argc, ++argv);
		mlen = 3;
        if (strncmp(minor, "readblob", mlen) == 0)
            return tcl_sql_readblob(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "reopen", mlen) == 0)
            return tcl_sql_reopen(dummy, interp, --argc, ++argv);
        return tcl_sql_usage(interp);
    }
    if (*minor == 's') {
		if (mlen < 2) mlen = 2;
		if (strncmp(minor, "setconnection", mlen) == 0)
            return tcl_sql_setconnection(dummy, interp, --argc, ++argv);
        if (mlen < 4) mlen = 4;
        if (strncmp(minor, "sqlca", mlen) == 0)
            return tcl_sqlca(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "sqlbreak", mlen) == 0)
            return tcl_sqlsigcmd(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "sqlexit", mlen) == 0)
            return tcl_sqlsigcmd(dummy, interp, --argc, ++argv);
        mlen = 5;
        if (strncmp(minor, "sqlda", mlen) == 0)
            return tcl_sqlda(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "sqldetach", mlen) == 0)
            return tcl_sqlsigcmd(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "sqldone", mlen) == 0)
            return tcl_sqlsigcmd(dummy, interp, --argc, ++argv);
        if (strncmp(minor, "sqld", mlen) == 0)
            return tcl_sqld(dummy, interp, --argc, ++argv);
        return tcl_sql_usage(interp);
    }
    if (*minor == 'w' && strncmp(minor, "writeblob", mlen) == 0)
        return tcl_sql_writeblob(dummy, interp, --argc, ++argv);
    return tcl_sql_usage(interp);
}
        
int
tcl_sql_run(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    char buf[25];
    int ret;
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " arg ?arg ...?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    stmt = argv[0];
    argc--;
    argv++;
    ret = sql_run(stmt, argc, argv);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_open(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    char buf[25];
    int ret;
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " arg ?arg ...?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    stmt = argv[0];
    argc--;
    argv++;
    ret = sql_open(stmt, argc, argv);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}
int
tcl_sql_close(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    char buf[25];
    int ret;
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " arg ?arg ...?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &ret, buf) != 1) {
        Tcl_AppendResult(interp, "argument to sql close not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    ret = sql_close(ret);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    /*sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);*/
    return TCL_OK;
}
int
tcl_sql_fetch(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    char buf[25];
    int fd, ret, retargc, dostrip;
    char **retargv, **sql_values();
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " arg ?arg ...?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &fd, buf) != 1) {
        Tcl_AppendResult(interp, "argument to sql fetch not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    if (argc >= 2 && argv[1] && sscanf(argv[1], "%d", &ret) == 1 && ret == 1)
        dostrip = 1;
    else dostrip = 0;
    ret = sql_fetch(fd);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    if (ret == 0) {
        retargv = sql_values(fd, &retargc, dostrip);
        if (!retargv) {
            Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
            "\"", (char *) NULL);
            return TCL_ERROR;
        }
        interp->result = Tcl_Merge(retargc, retargv);
        interp->freeProc = (Tcl_FreeProc *) free;
        return TCL_OK;
    }
    return TCL_OK;
}
int
tcl_sql_exists(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *arg0, *table, *column, *value = NULL, *where = NULL;
    char buf[25];
    int ret;
    if (argc < 3) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " table column ?value ?where?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    table = argv[0];
    column = argv[1];
    if (argv[2]) {
        value = argv[2];
        if (argv[3])
            where = argv[3];
    }
    ret = sql_exists(table, column, value, where);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_reopen(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    char buf[25];
    int ret;
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " arg ?arg ...?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &ret, buf) != 1) {
        Tcl_AppendResult(interp, "argument to sql reopen not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    argc--;
    argv++;
    ret = sql_reopen(ret, argc, argv);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_explain(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    char buf[25];
    int ret;
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " arg ?arg ...?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &ret, buf) != 1) {
        Tcl_AppendResult(interp, "argument to sql explain not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    ret = sql_explain(ret);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_getenv(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *p;
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " arg ?arg ...?\"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    p = getenv(argv[0]);
    if (!p) p = "";
    Tcl_SetResult(interp, p, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_geterror(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *p, *sql_geterror();
    int ret;
    p = sql_geterror();
    if (!p) p = "";
    Tcl_SetResult(interp, p, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sqlca(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    int retargc;
    char **retargv, **sql_sqlca();
    char *arg0 = argv[0];

    retargv = sql_sqlca(&retargc);
    if (!retargv) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    interp->result = Tcl_Merge(retargc, retargv);
    interp->freeProc = (Tcl_FreeProc *) free;
    return TCL_OK;
}

int
tcl_sqld(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    char buf[25];
    int ret, type_ld;
    if (argc < 3) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " <fd> <in> \"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &ret, buf) != 1) {
        Tcl_AppendResult(interp, "argument to sql sqld not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &type_ld, buf) != 1) {
        Tcl_AppendResult(interp, "argument 2 to sql sqld not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    ret = sql_sqld(ret, type_ld);
    if (ret == -2) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sqlda(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    int retargc;
    char **retargv, **sql_sqlda();
    char *stmt, *arg0;
    char buf[25];
    int ret, fd, num, type_ld;
    if (argc < 4) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " <fd> <in> <num> \"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &fd, buf) != 1) {
        Tcl_AppendResult(interp, "argument to sql sqlda not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &type_ld, buf) != 1) {
        Tcl_AppendResult(interp, "argument 2 to sql sqlda not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &num, buf) != 1) {
        Tcl_AppendResult(interp, "argument 3 to sql sqlda not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    retargv = sql_sqlda(fd, type_ld, num, &retargc);
    if (!retargv) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    interp->result = Tcl_Merge(retargc, retargv);
    interp->freeProc = (Tcl_FreeProc *) free;
    return TCL_OK;
}

int
tcl_sql_sqlcols(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    int retargc;
    char **retargv, **sql_sqlcols();
    char *stmt, *arg0;
    char buf[25];
    int ret, fd, num, type_ld;
    if (argc < 3) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " <fd> <in> \"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &fd, buf) != 1) {
        Tcl_AppendResult(interp, "argument to sql sqlcols not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    argc--;
    argv++;
    if (sscanf(argv[0], "%d%1s", &type_ld, buf) != 1) {
        Tcl_AppendResult(interp, "argument 2 to sql sqlcols not an integer ==>",
            argv[0], (char *) NULL);
        return TCL_ERROR;
    }
    retargv = sql_sqlcols(fd, type_ld, arg0, &retargc);
    if (!retargv) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    interp->result = Tcl_Merge(retargc, retargv);
    interp->freeProc = (Tcl_FreeProc *) free;
    return TCL_OK;
}

int
tcl_sql_getdatabase(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *p, *sql_getdatabase();
    int ret;
    p = sql_getdatabase();
    if (!p) p = "";
    Tcl_SetResult(interp, p, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_finish(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *p, *sql_getdatabase();
    int ret;
    char buf[25];
	char *arg0;

	arg0 = argv[0];

    ret = sql_finish();
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_begin_work(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    int ret;
    char buf[25];
	char *arg0;

	arg0 = argv[0];
    ret = sql_begin();
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_commit(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    int ret;
    char buf[25];
	char *arg0;

	arg0 = argv[0];

    ret = sql_commit();
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_rollback(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    int ret;
    char buf[25];
	char *arg0;

	arg0 = argv[0];

    ret = sql_rollback();
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_database(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *p = NULL;
	int exclusive = 0;
    char buf[25];

    arg0 = argv[0];
    if (argc >= 2) p = argv[1];
    if (argc >= 3) {
		if (argv[2][0] == 'e' || argv[2][0] == '1')
			exclusive = 1;
	}
    ret = sql_database(p, exclusive);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);

    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_readblob(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *table = NULL;
    char *column = NULL;
    char *rowidclause = NULL;
    char *intofile = NULL;
	int appendmode = 0;
    char buf[25];

    arg0 = argv[0];
    if (argc < 5) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
                " table column rowid intofile ?append\"", (char *) NULL);
        return TCL_ERROR;
    }
    if (argc >= 2) table = argv[1];
    if (argc >= 3) column = argv[2];
    if (argc >= 4) rowidclause = argv[3];
    if (argc >= 5) intofile = argv[4];
    if (argc >= 6) {
		if (argv[5][0] == 'a' || argv[5][0] == '1')
			appendmode = 1;
	}
    ret = sql_readblob(table, column, rowidclause, intofile, appendmode);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);

    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_writeblob(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *table = NULL;
    char *column = NULL;
    char *rowidclause = NULL;
    char *fromfile = NULL;
	int fromsize = -1;
    char buf[25];

    arg0 = argv[0];
    if (argc < 5) {
        Tcl_AppendResult(interp, "wrong # args: should be \"sql ", argv[0],
          " table column rowid fromfile|null ?size\"", (char *) NULL);
        return TCL_ERROR;
    }
    if (argc >= 2) table = argv[1];
    if (argc >= 3) column = argv[2];
    if (argc >= 4) rowidclause = argv[3];
    if (argc >= 5) fromfile = argv[4];
    if (argc >= 6) {
		fromsize = atoi(argv[5]);
	}
    ret = sql_writeblob(table, column, rowidclause, fromfile, fromsize);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);

    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sqlsigcmd(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *p = NULL;
    char buf[25];

    arg0 = argv[0];
	p = arg0;
	if (p) {
		if (strncmp(p, "sqlbreak", 4) == 0) p = "sqlbreak";
		else if (strncmp(p, "sqlexit", 4) == 0) p = "sqlexit";
		else if (strncmp(p, "sqldone", 5) == 0) p = "sqldone";
		else if (strncmp(p, "sqldetach", 5) == 0) p = "sqldetach";
	}

    ret = sql_sigcmd(p);
    if (ret == -1) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);

    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_connect(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *p = NULL;
    char buf[25];
	char *uid = NULL, *pw = NULL, *cname = NULL;
	int i, with_contrans = 0;

    arg0 = argv[0];
    if (argc >= 2) p = argv[1];
	for (i = 2; i < argc; i++) {
		if (strncmp(argv[i], "user", 3) == 0) {
			uid = argv[i+1];
			i++;
		} else if (strncmp(argv[i], "password",1) == 0 || 
			strncmp(argv[i], "using",3) == 0) {
			pw = argv[i+1];
			i++;
		} else if (strncmp(argv[i], "with_concurrent_transaction",1) == 0) {
			with_contrans = 1;
		} else if (strncmp(argv[i], "as",1) == 0) {
			cname = argv[i+1];
			i++;
		}
	}

	/*
    if (argc >= 3) uid = argv[2];
    if (argc >= 4) pw = argv[3];
    if (argc >= 5) cname = argv[4];
    if (argc >= 6) {
		if (argv[5][0] == 'w' || argv[5][0] == '1') 
			with_contrans = 1;
	}
	*/

    ret = sql_connect(p, uid, pw, cname, with_contrans);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);

    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_disconnect(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *p = NULL;
    char buf[25];

    arg0 = argv[0];
    if (argc >= 2) p = argv[1];
    ret = sql_disconnect(p);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);

    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_sql_setconnection(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *p = NULL;
	int dormant = 0;
    char buf[25];

    arg0 = argv[0];
    if (argc >= 2) p = argv[1];
    if (argc >= 3) {
		if (argv[2][0] == 'd' || argv[2][0] == '1') {
			dormant = 1;
		}
	}
    ret = sql_setconnection(p, dormant);
    if (ret < 0) {
        Tcl_AppendResult(interp, "\"sql ", arg0, ":", sql_geterror(), 
        "\"", (char *) NULL);
        return TCL_ERROR;
    }
    sprintf(buf, "%d", ret);

    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}

int
tcl_system(dummy, interp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    char *stmt, *arg0;
    int ret;
    char *p;
    char buf[25];
    if (argc < 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                " arg \"", (char *) NULL);
        return TCL_ERROR;
    }
    arg0 = argv[0];
    argc--;
    argv++;
    ret = system(argv[0]);
    sprintf(buf, "%d", ret);
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}
