#
# Set.tcl,v 1.2 1992/05/09 15:54:09 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/Set.tcl,v 1.2 1992/05/09 15:54:09 snl Exp
#
# HISTORY
#
# Set.tcl,v
# Revision 1.2  1992/05/09  15:54:09  snl
# test
#
# Revision 1.1.1.1  92/05/08  19:46:10  snl
# bos 1.2
# 
# Revision 1.2  92/04/09  22:44:12  snl
# added maxCardinality
# 
# Revision 1.1  92/03/08  23:33:40  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:06:41  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:12:37  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:42:43  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:35:00  snl
# Initial revision
# 
#
List refineWith Set

SetTraits defMethod put {args} {
  set mc [$self maxCardinality]
  foreach a $args {
    if {$mc > 0 && ([$self [$self listParent]:length] >= $mc)} {
      error "Set $self maxCardinality $mc -- cannot put $a"
    }
    if {[expr {[$self [$self listParent]:index $a] == -1}]} {
      $self [$self listParent]:append $a
    }
  }
}
SetTraits defMethod contains {x} {
  if {[expr {[$self [$self listParent]:index $x] == -1}]} {
    return 0
  } else {
    return 1
  }
}
SetTraits hideSuper append
SetTraits hideSuper prepend
SetTraits hideSuper reorder
SetTraits defMethod difference {otherSet} {
  set diff [System gensym]
  Set copy $diff
  $self foreach elt {
    if {![$otherSet contains $elt]} {
      $diff put $elt
    }
  }
  return $diff
}
SetTraits defMethod intersection {otherSet} {
  set int [System gensym]
  Set copy $int
  $self foreach elt {
    if {[$otherSet contains $elt]} {
      $int put $elt
    }
  }
  return $int
}
SetTraits defMethod union {otherSet} {
  set union [System gensym]
  $self copy $union
  $otherSet foreach elt {
    if {![$union contains $elt]} {
      $union put $elt
    }
  }
  return $union
}
SetTraits defMethod set {name value} {
  if ![string compare $name maxCardinality] {
    if {[$self [$self listParent]:length] > $value} {
      error "Set $self has cardinality > $value already -- cannot set maxCardinality to $value"
    }
  }
  return [$self [$self listParent]:set $name $value]
}

Set addSlot maxCardinality 0

