;;;;
;;;; This file is put into the public domain, Pertti Kellom\"aki, 1990
;;;;
;;;; This is a simple scanner that goes along with the sample grammar
;;;; in file samplegram.tau. See samplegram.tau for more details.
;;;; 

(define input-port #f)
(define make-token #f)
(define *procedure-names* '())
(define line-number 1)

(define (skip-whitespace port)
  (let loop ((next (peek-char port)))
    (cond ((eof-object? next))
	  ((char-whitespace? next)
	   (if (char=? #\newline next)
	       (set! line-number
		     (+ line-number 1)))
	   (read-char port)
	   (loop (peek-char port))))))

(define (string-upcase string)
  (list->string (map char-upcase (string->list string))))

(define character-tokens '(#\; #\. #\, #\( #\) ))

(define reserved-words '(+ := procedure id int program begin end while do))

(define (scan)
  (skip-whitespace input-port)
  (let ((first (peek-char input-port)))
    (cond ((eof-object? first)
	   (make-token 'end-of-file 'end-of-file line-number "test"))
	  ((member first character-tokens)
	   (read-char input-port)
	   (make-token first (list->string (list first)) line-number "test"))
	  (else
	   (let loop ((chars (list (read-char input-port))))
	     (if (not (char-whitespace? (peek-char input-port)))
		 (loop (cons (read-char input-port) chars))
		 
		 (let ((symbol-name (string-upcase
				     (list->string (reverse chars))))
		       (print-name  (list->string (reverse chars)))
		       (first-char (car (reverse chars))))
		   (cond ((char-numeric? first-char)
			  (make-token 'int
				      (string->number print-name)
				      line-number
				      "test"))
			 ((member (string->symbol symbol-name)
				  reserved-words)
			  (make-token (string->symbol symbol-name)
				      print-name
				      line-number
				      "test"))
			 (else
			  (make-token 'id
				      print-name
				      line-number
				      "test"))))))))))

(define (go filename)
  (set! input-port (open-input-file filename))
  (set! line-number 1)
  (set! make-token (parser 'token-maker))
  (let ((parser (parser 'parse)))
    (close-input-port input-port)
    parser))
