; $Header: /home/campbell/Languages/Scheme/scm/x-scm/RCS/assert.scm,v 1.1 1992/07/03 03:06:52 campbell Beta $
;
; Assertion checking macro
;
; Usage:
;
;	#.(assert 'expr . args)
;
; Prints a message and aborts if expr evalutes to #f.  Optional args
; are also printed.
;
; If you want to disable (most of) this for performance after things
; are debugged, just define assert:disabled to #t.
;
;  Author: Larry Campbell (campbell@redsox.bsw.com)
; 
;  Copyright 1992 by The Boston Software Works, Inc.
;  Permission to use for any purpose whatsoever granted, as long
;  as this copyright notice remains intact.  Please send bug fixes
;  or enhancements to the above email address.

(require 'format)

(define assert:disabled #f)

(define (assert condition . args)
  (let ((e (format #f "Assertion failed: ~A~%" condition)))
    (if assert:disabled
	#t
	`(if (not ,condition)
	     (let ((msg ,e))
	       ,(if (not (null? args))
		    `(set!
		      msg
		      (string-append
		       msg
		       ,@(map
			  (lambda (a)
			    `(format #f "    ~A=~A~%" ',a ,a))
			  args))))
	       (if ,*load-pathname*
		   (set!
		    msg
		    (string-append
		     msg (format #f "  In file ~A, line ~A"
				 ,*load-pathname* ,(line-number)))))
	       (error msg))))))
