;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; util.sc -- some useful stuff used by various stox modules.
;;;

;;; $Id: util.sc,v 1.1 91/09/15 00:58:32 johani Exp $

(module stoxutil)

(define-c-external (c-getenv pointer) pointer "getenv")
(define-c-external (c-readable pointer) int "filereadp")

;;; add-new-args -- return a new arg-list with the new items added that did
;;;                 not have their tags present in the original arg-list.
(define (add-new-args . args)
  (let ((arg-list (car (last-pair args))))
    (let loop ((new-args (remq arg-list args))
	       (arg-list arg-list) )
      (cond ((null? new-args) arg-list)
	    ((memq (car new-args) arg-list) (loop (cddr new-args) arg-list))
	    (else (loop (cddr new-args)
			(cons* (car new-args) (cadr new-args) arg-list)))))))

(define (getenv str)
  (c-string->string (c-getenv str)) )

(define (file-readable? filename)
  (zero? (c-readable filename)) )
