;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; container.sc -- a widget that can adjust its size to fit a given
;;;                 box.
;;;

;;; $Id: container.sc,v 1.2 91/09/15 00:58:25 johani Exp $

(module stoxcont)

(define-external widget stoxwidget)

(include "../include/masks.sch")
(include "../include/util.sch")

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

(define-class (container . args)
  (locals
   (scr    ((match-arg 'parent 'no-default args) 'screen))
   (gcache (match-arg 'gcache (scr 'gcache) args))
   (title  (match-arg 'title "SCIX Container" args))
   (border-pad (match-arg 'border-pad 0 args))
   (box #f)
   (the-mask (make-configure-value-mask))
   (semantics `(((Anytime . ConfigureNotify)
		 Anytime
		 ,(lambda (e)
		    (if (and box (or (not (= (box 'width) (e 'width)))
				     (not (= (box 'height) (e 'height))) ))
			(begin
			  (box 'set-width! (e 'width))
			  (box 'set-height! (e 'height))
			  (box 'stox-arrange) )))))) )
  (inherit
   (widget (cons* 'value-mask (make-window-value-mask
			       `(background-pixel ,(gcache 'background))
			       `(event-mask
				 ,(make-mask 'event 'StructureNotify)))
		  'dfsm-data (list 'Anytime #f semantics)
		  args)) )
  (methods
   (set-box! (lambda (new-box)
	       (set! box new-box)
	       (box 'stox-arrange)
	       (me 'resize (box 'width) (box 'height)) ))
   )
  (init
   (me 'changeproperty 'replace 'wm_name 'string 8 title)
   ))

