;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; A new go at mask objects. For simple bitmasks, it seems unnecessary
;;; to use the mask object provided. Let's see if this is better...

(module scixbmsk)

(define make-mask
  (let ((mask-formats '((Event
			 (KeyPress             .       #x1)
			 (KeyRelease           .       #x2) 
			 (ButtonPress          .       #x4)
			 (ButtonRelease        .       #x8)
			 (EnterWindow          .      #x10)
			 (LeaveWindow          .      #x20)
			 (PointerMotion        .      #x40)
			 (PointerMotionHint    .      #x80)
			 (Button1Motion        .     #x100)
			 (Button2Motion        .     #x200)
			 (Button3Motion        .     #x400)
			 (Button4Motion        .     #x800)
			 (Button5Motion        .    #x1000)
			 (ButtonMotion         .    #x2000)
			 (KeyMapState          .    #x4000)
			 (Exposure             .    #x8000)
			 (VisibilityChange     .   #x10000)
			 (StructureNotify      .   #x20000)
			 (ResizeRedirect       .   #x40000)
			 (SubstructureNotify   .   #x80000)
			 (SubstructureRedirect .  #x100000)
			 (FocusChange          .  #x200000)
			 (PropertyChange       .  #x400000)
			 (ColormapChange       .  #x800000)
			 (OwnerGrabButton      . #x1000000) )
			(PointerEvent
			 (ButtonPress          .       #x4)
			 (ButtonRelease        .       #x8)
			 (EnterWindow          .      #x10)
			 (LeaveWindow          .      #x20)
			 (PointerMotion        .      #x40)
			 (PointerMotionHint    .      #x80)
			 (Button1Motion        .     #x100)
			 (Button2Motion        .     #x200)
			 (Button3Motion        .     #x400)
			 (Button4Motion        .     #x800)
			 (Button5Motion        .    #x1000)
			 (ButtonMotion         .    #x2000)
			 (KeyMapState          .    #x4000) )
			(DeviceEvent 
			 (KeyPress             .       #x1)
			 (KeyRelease           .       #x2) 
			 (ButtonPress          .       #x4)
			 (ButtonRelease        .       #x8)
			 (PointerMotion        .      #x40)
			 (Button1Motion        .     #x100)
			 (Button2Motion        .     #x200)
			 (Button3Motion        .     #x400)
			 (Button4Motion        .     #x800)
			 (Button5Motion        .    #x1000)
			 (ButtonMotion         .    #x2000) )
			(Keybutmask 
			 (Shift   .    #x1)
			 (Lock    .    #x2)
			 (Control .    #x4)
			 (Mod1    .    #x8)
			 (Mod2    .   #x10)
			 (Mod3    .   #x20)
			 (Mod4    .   #x40)
			 (Mod5    .   #x80)
			 (Button1 .  #x100)
			 (Button2 .  #x200)
			 (Button3 .  #x400)
			 (Button4 .  #x800)
			 (Button5 . #x1000) )
			(Keymask
			 (Shift   .    #x1)
			 (Lock    .    #x2)
			 (Control .    #x4)
			 (Mod1    .    #x8)
			 (Mod2    .   #x10)
			 (Mod3    .   #x20)
			 (Mod4    .   #x40)
			 (Mod5    .   #x80) )
			(ConfigureRequest              ; Used only in event #23
			 (x            . #x1)
			 (y            . #x2)
			 (width        . #x4)
			 (height       . #x8)
			 (border-width . #x10)
			 (sibling      . #x20)
			 (stack-mode   . #x40) )))
	(msgs (append '(names set! unset! set-mask! mask length clear!
			      or-mask! set? unset?) )))
    (lambda (name . bits)
      (let ((the-mask 0) (the-format (assq name mask-formats)))
	(define (me msg . args)
	  (cond ((eq? msg 'set!)
		 (for-each (lambda (name)
			     (let ((the-pair (assq name (cdr the-format))))
			       (if the-pair
				   (set! the-mask
					 (bit-or the-mask (cdr the-pair)) )
				   (error 'mask "No such field: ~a" name) )))
			   args))
		((eq? msg 'mask) the-mask)
		((eq? msg 'names) (map car (cdr the-format)))
		((eq? msg 'unset!)
		 (for-each (lambda (name)
			     (let ((the-pair (assq name (cdr the-format))))
			       (if the-pair
				   (set! the-mask
					 (bit-and the-mask
						  (bit-not (cdr the-pair)) ))
				   (error 'mask "No such field: ~a" name) )))
			   args))
		((eq? msg 'clear!) (set! the-mask 0))
		((eq? msg 'set-mask!) (set! the-mask (car args)))
		((eq? msg 'length) 'what-is-this-used-for?)
		((eq? msg 'or-mask!) 'what-is-this-used-for?)
		((eq? msg 'set?)
		 (let ((the-pair (assq (car args) (cdr the-format))))
		   (if the-pair
		       (not (zero? (bit-and the-mask (cdr the-pair))))
		       (error 'mask "No such field: ~a" name) )))
		((eq? msg 'unset?)
		 (let ((the-pair (assq (car args) (cdr the-format))))
		   (if the-pair
		       (zero? (bit-and the-mask (cdr the-pair)))
		       (error 'mask "No such field: ~a" name) )))
		((eq? msg 'object-class) 'mask)
		((eq? msg 'supported-messages)
		 (append msgs (map car (cdr the-format))))
		(else (error 'mask "Undefined operation: ~a" msg)) ))
	
	(apply me (cons 'set! bits))
	me))))

;;; Temporary
(define make-bitmask make-mask)
