;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; demo-bounce -- a black ball bounces around in a white window.
;;; Hakan Huss, KTH and Johan Ihren, KTH

;;; $Id: bounce.sc,v 2.2 91/09/15 01:01:57 johani Exp $

(module demobounce (top-level demo-bounce))

(include "../include/stox.sch")
(include "../include/scix.sch")

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

(define (demo-bounce width height scr)
  (let* ((w (window 'make 'width width 'height height 'screen scr
		    'mask (make-window-value-mask
			   `(background-pixel ,(scr 'whitepixel))
			   `(event-mask
			     ,(make-mask 'event 'StructureNotify)))))
	 (ball-w (window 'make 'width 50 'height 50 'parent w 'screen scr
			 'mask (make-window-value-mask
				`(background-pixel ,(scr 'whitepixel))
				`(event-mask 
				  ,(make-mask 'event 'Exposure 'StructureNotify
					      'VisibilityChange)))))
	 (mygc (gc 'make 'mask (make-gc-value-mask 
				`(foreground ,(scr 'blackpixel))
				`(background ,(scr 'whitepixel))
				`(arc-mode Chord) )
		   'screen scr))
	 (ball (polyfillarc 'make `((0 0 50 50 0 ,(* 64 360)))))
	 (terminate #f)
	 (xmax 0) (ymax 0) (xpos 2) (ypos 2) (xmin 0) (ymin 0) (dx 2) (dy 2)
	 (ball-mask (make-configure-value-mask `(x ,xpos) `(y ,ypos)))
	 (quit-button (button 'make 'x 20 'y 20 'parent w 'screen scr
			      'label "Quit"
			      'on-action (lambda (e)
					   (w 'destroywindow)
					   (mygc 'freegc)
					   (scr 'flush!)
					   (set! terminate #t) ))) )
    
    (w 'add-callback! 'ConfigureNotify (lambda (event window)
					 (set! xmax (- (event 'width) 50))
					 (set! ymax (- (event 'height) 50)) ))

    (ball-w 'add-callback! 'Expose (lambda (event window)
				     (if (and (zero? (event 'count))
					      (not terminate) )
					 (begin
					   (ball-w 'draw (list ball) mygc)
					   (scr 'flush!) ))))

    (w 'changeproperty 'replace 'wm_name 'string 8 "SCIX Bounce!")
    (quit-button 'stox-activate)
    (ball-w 'mapwindow)
    (w 'mapwindow)
    (ball-w 'configurewindow ball-mask)
    (scr 'flush!)
    (let loop ((continue (not terminate)))
      (if continue
	  (begin
	    (cond ((< xpos xmin) (set! dx 2))
		  ((> xpos xmax) (set! dx -2)) )
	    (cond ((< ypos ymin) (set! dy 2))
		  ((> ypos ymax) (set! dy -2)) )
	    (set! xpos (+ xpos dx))
	    (set! ypos (+ ypos dy))
	    (ball-mask 'set! `(x ,xpos))
	    (ball-mask 'set! `(y ,ypos))
	    (ball-w 'configurewindow ball-mask)
	    (scr 'flush!)
	    (msg-handler 'scix-process-events scr)
	    (loop (not terminate)) )))))

    ;;(scix-process-events scr) 
    ;;(msg-handler 'mainloop (lambda () terminate) (list scr))))

;;; The two functions below are used only when bounce is compiled
;;; as a stand-alone application.

(define (usage)
  (display "Usage: bounce [-width size] [-height size] [-display display]") 
  (newline))

(define (do-bounce clargs)
  (let ((dpy #f) (width 200) (height 500))
    (let loop ((ls (cdr clargs)))
      (cond ((null? ls) #t)
	    ((and (equal? (car ls) "-width")
		  (not (null? (cdr ls)))
		  (string->number (cadr ls)) )
	     (set! width (string->number (cadr ls)))
	     (loop (cddr ls)) )
	    ((and (equal? (car ls) "-height")
		  (not (null? (cdr ls)))
		  (string->number (cadr ls)) )
	     (set! height (string->number (cadr ls)))
	     (loop (cddr ls)) )
	    ((and (equal? (car ls) "-display")
		  (not (null? (cdr ls)))
		  (string? (cadr ls)) )
	     (set! dpy (xdisplay 'make (cadr ls)))
	     (loop (cddr ls)) )
	    (else
	     (usage)
	     (exit) )))
    (if (not dpy)
	(set! dpy (xdisplay 'make "")) )
    (demo-bounce width height (dpy 'defaultscreen)) ))
