;;; standalone-wheel.sc -- a beautiful color wheel that rotates slowly
;;;                       "for better effect" ;-) The stand-alone version.
;;;                       Hakan Huss, KTH and Johan Ihren, KTH

;;; $Header: /nfs/deneb/src0/johani/scix-0.95/demo/RCS/standalone-wheel.sc,v 1.2 90/03/20 23:36:46 johani Exp $

(module wheel (main do-wheel))

(include "../include/objects.sch")
(include "../include/lw-objects.sch")
(include "../include/msg-handler.sch")
(include "../include/masks.sch")

(include "wheel.sc")

(define (usage)
  (display "Usage: wheel [-size size] [-display display]") 
  (newline))

(define (do-wheel clargs)
  (let ((dpy #f) (size 400))
    (let loop ((ls (cdr clargs)))
      (cond ((null? ls) #t)
	    ((and (equal? (car ls) "-size")
		  (not (null? (cdr ls)))
		  (string->number (cadr ls)) )
	     (set! size (string->number (cadr ls)))
	     (loop (cddr ls)) )
	    ((and (equal? (car ls) "-display")
		  (not (null? (cdr ls)))
		  (string? (cadr ls)) )
	     (set! dpy (make-display (cadr ls)))
	     (loop (cddr ls)) )
	    (else
	     (usage)
	     (exit) )))
    (if (not dpy)
	(set! dpy (make-display "")) )
    (demo-wheel size (dpy 'defaultscreen)) ))
