* Stack when we get control:
*
* 0: sp ->  return address to t startup code
* 4:        argument 1 to T (start_address)
* 8:        argument 2 to T (data_address)
* C:        argument 3 to T (fault_handler_xenoid)
* ...
*
* JUMP_TO_T is called by value.  The first three arguments are 
* start_addresss, data_address, and sfh_xenoid.  The sfh_xenoid is 
* in this file, and the third argument to JUMP_TO_T is clobbered
* with a pointer to it.

* The slink is assumed to be the first thing in the data section,
* and is saved into the fault handler's ecb, so that we may regain
* addressibility to T after a fault.

    module jtt


********  T system dependencies

p          equ a0
tp         equ a5
nil_reg    equ d7

nil_tag    equ 3

xenoid_header                  equ 57

exception_handler_slink_offset equ 49

******** 

*
*  PROCEDURE jump_to_t(start, data_address, sfh_dummy, ....); OPTIONS(VAL_PARAM);
*
    data
data_start equ *
jump_to_t equ *
    dc.w    $4ef9                   * jump long absolute instruction
    ac      pure_jump_to_t          * pure code entry point
    ac      data_start              * data section pointer
    dc.w    0                       * flag word (unused)

    proc                 
    entry jump_to_t
pure_jump_to_t equ *
    move.l db,d2
    move.l 4(sp),d1                       * t start routine (arg 1)
    move.l 6(a0),db                       * addressibility to local data
    move.l db,4(sp)                       * save db
    move.l d2,saved_db
    move.l sb,saved_sb                    * save sb
    move.l (sp)+,saved_return             * pop return address and save
    move.l 4(sp),d0                       * get data area address (arg 2)
    addq.l #nil_tag,d0                    * ..add nil tag to make slink
    move.l d0,the_saved_slink             * ..cache slink pointer for fault handler

    lea    2+sfh_xenoid-data_start(db),a1 * fault handler xenoid extend pointer
    move.l a1,8(sp)                       * ...pass to t (arg 3)
    move.l d1,p
    move.l -2(p),tp                       * t calling sequence

    jsr    (tp)
    move.l (sp),db                               
    move.l saved_return,-(sp)
    move.l saved_sb,sb
    move.l saved_db,db
    rts     


* Fault Handling

* This is how we get control of machine synchronous & asynchronous faults
* The Aegis nucleus fim catches  fault & sets up the diagnostic frame on our
* stack, then it calls the static fault handler passing a pointer to the
* diagnostic frame and a deferred? flag.  We align the stack and then 
* format the fault frame for T.  
*
* 100 dc.l alignment area size (offset to diag frame)  <== SP
* 000 dc.l old SP
* 100 dc.l fault SP (redundant for interrupt dispatcher ease)
* 000 some number of bytes for alignment
* ... some randomness in here, old SP points into this
*      old SP ->  0: saved db
*                 4: saved sb
*                 8: return address of caller
*                12: argument 1 (frame)
*                16: argument 2 (deferred?)
* ... dc.w $DFDF                <---- Apollo dignostic frame begins
* ... dc.l fault status
* ... dc.l D0

*%include '/os/ins/fault.ins.asm'
%include 'fault.ins.asm'

    data
sfh_ecb
    dc.w $4ef9
    ac sfh_pure
the_saved_slink
    ac 0                    * this is filled in with a pointer to the slink
*                           * (which is the first thing in the data section)
saved_return
    ac 0
saved_sb
    ac 0
saved_db
    ac 0
    dc.w 0

sfh_procedure
    ac sfh_ecb
    ac sfh_ecb

* do long word alignment !!!  (we got it here by accident, if we got it)
* 
sfh_xenoid
    dc.l xenoid_header                * xenoid header
    ac sfh_procedure

* when control here, we save DB & SB, then stack looks like
*
*    sp->  0: saved db
*          4: saved sb
*          8: return address of caller
*          12: argument 1 (frame)
*          16: argument 2 (deferred?)

      proc
sfh_pure
     move.l sb,-(sp)
     move.l db,-(sp)              * save regs needed to resume from fault

     move.l 6(a0),a1              * restore slink for T
     move.l a1,nil_reg

     move.l 12(sp),a0           * diagnostic frame
     move.l sp,d2               * saved sp

* A0 points to top of diagnostic frame
* D6 points into stack at a known spot so that we can find our way
*    past the alignment bytes when we try to return (old SP)


    move.l sp,d0           * copy sp
    andi.b #255-3,d0       * d0 is longword aligned version of sp

    exg d0,sp              * put aligned sp into effect

    move.l df_a7-df_start(a0),-(sp)   * get fault time SP
    move.l d2,-(sp)          * save a spot after alignment (old SP), to return

    move.l a0,-(sp)          * slot for diag frame offset (init to diag frame)
    move.l sp,d0             * (copy sp to data reg because 68k is a loser)
    sub.l d0,(sp)            * ... sub makes slot = displacement to diag frame

    move.l nil_reg,a1               * slink into address reg

    move.l df_status-df_start(a0),d5
    move.l exception_handler_slink_offset(a1),p
    move.l -2(p),tp
    jmp (tp)




