*  PROCEDURE data_move(in from, dest : byte_ptr_t; lgth : linteger);
*
            module  data_move
*
source      equ     4(SP)               source ptr
dest        equ     8(SP)               destination ptr
len         equ     12(SP)              length (32 bits)
*
            entry.p data_move
data_move ds.w 0
*
            move.l  len,D0
            beq.s   retrn
            move.l  source,A1
            move.l  dest,A2
            move.l  D0,D1
            sub.l   #4,D0
            lsr.l   #5,D0
nextw       move.l  (A1)+,(A2)+
            move.l  (A1)+,(A2)+
            move.l  (A1)+,(A2)+
            move.l  (A1)+,(A2)+
            move.l  (A1)+,(A2)+
            move.l  (A1)+,(A2)+
            move.l  (A1)+,(A2)+
            move.l  (A1)+,(A2)+
            dbra D0,nextw
retrn       rts

*
* PROCEDURE relocate( count: linteger; relocs: univ_ptr; base: univ_ptr; at: univ_ptr );
*
* BEGIN
*    i := 0;
*    WHILE i < count DO BEGIN
*        ds_index := relocs^[i] DIV 4;
*        data_p^[ds_index] := data_p^[ds_index] + integer32( at );
*        i := i + 1;
*        END;
* END;
* 

count       equ     4(SP)               how many?
relocs      equ     8(SP)               array of longwords to change
base        equ     12(SP)              abs pointer to add
at          equ     16(SP)              (memory)        

*
            entry.p relocate
relocate ds.w 0
*
        move.l  count,d0
        subq.l  #1,d0
        move.l  at,d1  
        move.l  relocs,a0
        move.l  base,a1 
*                               * Index is d2

        bra.s   top

ttop
        swap    d0              * tricky!

top
        move.l  (a0)+,d2        * d2 is index
        add.l   d1,0(a1,d2.l)   * add at to index off of base
*
        dbra    d0,top
        swap    d0              * check high word (stupid machine)
        dbra    d0,ttop

        rts


