# The MPE/iX linker doesn't complain about unresolved symbols, and so the only
# way to test for unresolved symbols in a program is by attempting to run it.
#
# MPE/iX lacks a fully functional native nm, so we need to use our fake nm
# script which will extract the symbol info from the native link editor and
# reformat into something nm-like.
# 
# Created for 5.003 by Mark Klein, mklein@dis.com.
# Substantially revised for 5.004_01 by Mark Bixby, markb@cccd.edu.
#
# Overriding PATH is a hack to force Configure to use our fake mpeix/nm script.
PATH="`dirname $PWD`/mpeix:$PATH"
prefix='/PERL/PUB'
archname='PA-RISC1.1'
bin="$prefix"
cc='gcc'
cccdlflags='none'
ccflags='-DMPE -D_POSIX_SOURCE -D_SOCKET_SOURCE -D_POSIX_JOB_CONTROL'
# Configure doesn't compile *and* run to test for dlerror() and dlopen().
d_dlerror='undef'
d_dlopen='undef'
# MPE doesn't support hard links.
d_link='undef'
# pwage and pwcomment exist in the struct, but are not supported or initialized.
d_pwage='undef'
d_pwcomment='undef'
# No such thing as blocks for bytestream files on MPE.
d_statblks='undef'
# The General Terminal Interface was never completed.
i_termios='undef'
installman1dir="$prefix/man/man1"
installman3dir="$prefix/man/man3"
lddlflags='-b'
libs='-lsvipc -lsocket -lm -lc'
locincpth='/usr/local/include /usr/contrib/include'
loclibpth='/usr/local/lib /usr/contrib/lib'
man1dir="$prefix/man/man1"
man3dir="$prefix/man/man3"
# This tells our fake nm not to pass the call to the real gcc nm.
nm_opt='-configperl'
optimize='-O2'
osname='mpeix'
osvers='5.5'
perlpath="$prefix/PERL"
ranlib='/bin/true'
scriptdir="$prefix"
startsh='#!/bin/sh'
startperl="#!$perlpath"
toke_cflags='ccflags="$ccflags -DARG_ZERO_IS_SCRIPT"'
# We want Configure to use our fake nm in mpeix/nm.
usenm='true'
