=head1 NAME

Games::FrogLump - An ASCII game for fun

=head1 SYNOPIS

 use Games::FrogLump;
 Games::FrogLump->new->run;

=head1 DESCRIPTION

This module is an ASCII game , It runs at command-line. Control the frogs jump to each side.

Play the game with command:

  froglump

=begin HTML

<p><img src="http://ww3.sinaimg.cn/large/a8e976cegw1ej24klqiqkj20gf07gt8t.jpg" /></p>

=end HTML

=head1 AUTHOR

jmcveigh <jmcveigh@outlook.com>

=cut

package Games::FrogLump;
use 5.012;
use Moo;

our $VERSION = '0.061';

use Time::HiRes;
our $FRAME_TIME = 1/20;

use Games::FrogLump::Game;
use Games::FrogLump::Frog;
use Games::FrogLump::Input;
use Games::FrogLump::Animation;

sub run {
    my $self = shift;
    my $game;
    my $restart;
    my $quit;

    while (!$quit) {

        if ( !$game ) {
            $game = Games::FrogLump::Game->new();
        }
        if ( $restart ){
            $game->restart;
        }
        $game->init;
        $game->draw;
        my $time = Time::HiRes::time;
      PLAY:
        while ( 1 ) {
            while ( defined(my $key = Games::FrogLump::Input::read_key) ) {
                my $cmd = Games::FrogLump::Input::key_to_cmd($key);
                if ( $cmd eq 'quit' ){
                    $quit = 1;
                    last PLAY;
                }
                if ( $cmd eq 'restart' ){
                    $restart = 1;
                    last PLAY;
                }
                if ( $cmd ) {
                    $game->act($cmd);
                }
            }
            if ( @{$game->animations} ){
                foreach my $animation ( @{$game->animations} ){
                    $game->remove_animation($animation) if $animation->end;
                    $animation->update;
                }
            }
            $game->draw;
            my $new_time = Time::HiRes::time;
            my $delta_time = $new_time - $time;
            my $delay = $FRAME_TIME - $delta_time;
            $time = $new_time;
            if ($delay > 0) {
                Time::HiRes::sleep($delay);
                $time += $delay;
            }
            if ( $game->win || $game->lose ){
                last PLAY;
            }
        }
        if ( $game->win ){
            $game->draw_win;
            $quit = 1;
        }
    }
    $game->draw_quit;
}
1;
