package BlankOnDev::config;
use strict;
use warnings FATAL => 'all';

# Import Module :
use JSON;
use JSON::XS;
use Term::ReadKey;
use BlankOnDev::Utils::file;

# Version :
require BlankOnDev::Version;
our $VERSION = $BlankOnDev::Version::VERSION;

# Our vars :
our $allconfig = {};
our $bzrCfg = {};
our $gitCfg = {};
our $r_bzrcfg = 0;
our $r_gitcfg = 0;

# Subroutine for option "config" :
# ------------------------------------------------------------------------
sub _config {
    my $confirmation;
    my $cache_auth;
    my $gitname;
    my $gitemail;
    my $git_username;
    my $git_password;
    my $home_dir = $ENV{"HOME"};

    # For GitHub Configure
    # ------------------------------------------------------------------------
    if (-e $home_dir.".gitconfig") {
        # Form Confirmation :
        print "You want reconfig github [y/n]:";
        chomp($confirmation = <STDIN>);
        if ($confirmation eq 'y') {

            my $read_fileCfg = BlankOnDev::Utils::file->read($home_dir.".gitconfig");
            my $name_git;
            my $email_git;
            if ($read_fileCfg =~ m/(name)\s(\=)\s(.*)/) {
                $name_git = $3;
            }
            if ($read_fileCfg =~ m/(email)\s(\=)\s(.*)/) {
                $email_git = $3;
            }

            # Print FORM :
            print "Enter your github fullname [$name_git] : ";
            chomp($gitname = <STDIN>);
            print "Enter your github email [$email_git] : ";
            chomp($gitemail = <STDIN>);
            if ($gitname eq '') {
                $gitname = $name_git;
            }
            if ($gitemail eq '') {
                $gitemail = $email_git;
            }
            system("git config --global user.name \"$gitname\"");
            system("git config --global user.email \"$gitemail\"");
        }

    } else {

        # GitHub Local Config :
        print "Enter your github fullname : ";
        chomp($gitname = <STDIN>);
        print "Enter your github email :";
        chomp($gitemail = <STDIN>);
        system("git config --global user.name \"$gitname\"");
        system("git config --global user.email \"$gitemail\"");
    }

    # For cache user and password git push :
    print "You want cache user and password git [y/n]: ";
    chomp($cache_auth = <STDIN>);
    if ($cache_auth eq 'y' or $cache_auth eq '') {
        system("git config --global credential.helper cache --timeout=86400");
    }

    # get List git config :
    system("git config --list");

    # For gpg gen key :


    # BlankOnDev Tools Setup :
    my $dir_data_boidev = $home_dir . "/.BlankOnDev";
    mkdir($dir_data_boidev);

    # Config Password :
#    print "Enter your github username : ";
#    chomp($git_username = <STDIN>);
#    print "Enter your github account password : ";
#    ReadMode('noecho');
#    $git_password = ReadLine(0);
}
# Subroutine for Bazaar Configure :
# ------------------------------------------------------------------------
sub bzr_config {
    # Define scalar :
    my $bzr_url = '';

    # Form :
    my $data_bzrcfg = $allconfig->{'bzr'};
    my $url_bzr = $data_bzrcfg->{'url'} if exists $data_bzrcfg->{'url'};
    if ($url_bzr eq '') {
        print "Enter bzr url : ";
        chomp($bzr_url = <STDIN>);
    } else {
        print "Enter bzr url [$url_bzr] : ";
        chomp($bzr_url = <STDIN>);
    }

    if ($bzr_url eq '') {
        $r_bzrcfg = 0;
    } else {
        $bzrCfg = {
            'url' => $bzr_url
        };
        $r_bzrcfg = 1;
    }
}
# Subroutine for Git Configure :
# ------------------------------------------------------------------------
sub git_config {
    # Define scalar :
    my $git_url = '';

    # Form :
    my $data_gitcfg = $allconfig->{'git'};
    my $url_git = $data_gitcfg->{'url'} if exists $data_gitcfg->{'url'};
    if ($url_git eq '') {
        print "Enter git url : ";
        chomp($git_url);
    } else {
        print "Enter git url [$git_url] : ";
        chomp($git_url);
    }

    if ($git_url eq '') {
        $r_gitcfg = 0;
    } else {
        $r_gitcfg = 1;
    }
}
# Subroutine for option "help" :
# ------------------------------------------------------------------------
sub _usage {
}

# Subroutine for read config :
# ------------------------------------------------------------------------
sub read_config {
    my $data = '';
    my $data_setup = _data_setup();
    my $dir_dev = $data_setup->{'dir_dev'};
    my $file_cfg = $data_setup->{'file_cfg'};
    my $loc_flcfg = $dir_dev.'/'.$file_cfg;

    # Get format data config :
    my $format_config = format_data();

    # Check File Config :
    if (-e $loc_flcfg) {
        my $get_allcfg = BlankOnDev::Utils::file->read($loc_flcfg);
        my $data_allcfg = decode_json($get_allcfg);
        my $size_allcfg = scalar keys($data_allcfg);
        if ($size_allcfg > 0) {
            $data = $data_allcfg;
        } else {
            $data = $format_config;
        }
    } else {
        BlankOnDev::Utils::file->create($file_cfg, $dir_dev, $format_config);
        $data = $format_config;
    }
    $allconfig = $data;
    return $data;
}
# Subroutine for blankon Config :
# ------------------------------------------------------------------------
sub _data_setup {
    my $home_dir = $ENV{"HOME"};
    my %data = (
        'dir_dev' => $home_dir . "/.BlankOnDev",
        'file_cfg' => 'boi.cfg',
    );
    return \%data;
}
# Subroutine for format data config :
# ------------------------------------------------------------------------
sub format_data {
    my %data = (
        'prepare' = 0,
        'build' => {
            'gpg' => {
                'name' => '',
                'email' => '',
                'passphrase' => '',
            },
        },
        'bzr' => {
            'url' => '',
        },
        'git' => {
            'url' => ''
        },
        'pkg' => {

        },
    );
    return \%data;
}
# Subroutine for list command :
# ------------------------------------------------------------------------
sub cmd_list {
    my %data = ();

    # Git Command :
    $data{'git'} = {
        'cfg-name' => 'git config --global user.name',
        'cfg-email' => 'git config --global user.email',
        'cfg-credential-cache' => 'git config --global credential.helper cache',
        'cfg-list' => 'git config --list',


    };
    return \%data;
}
1;