#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/CustomPlugin.pm
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package CustomPlugin;

use Moose;
use namespace::autoclean;

extends 'Dist::Zilla::Plugin::InlineFiles';

use Dist::Zilla::File::FromCode;
use Dist::Zilla::File::InMemory;

after gather_files => sub {
    my ( $self) = @_;
    $self->add_file( Dist::Zilla::File::FromCode->new(
        name => 'GeneratedFile.txt',
        code_return_type => 'bytes',
        code => sub {
            "Generated content.\n"
        }
    ) );
    my $file = Dist::Zilla::File::InMemory->new(
        name => 'lib/GeneratedModule.pm',
        content => join( "\n",
            "package GeneratedModule;",
            "",
            "1;"
        ) . "\n"
    );
    $self->add_file( $file );
};

1;

__DATA__
__[lib/InlineModule.pm]__
package InlineModule;
1;
__END__

# end of file #
