use strict;
use warnings;

use Test::More;
use Tunein::Streams;
$|= 1;

#plan tests => 6;
my $number_of_tests_2run = 6;

use lib 't', '.';

my $station = new Tunein::Streams('http://tunein.com/radio/987-KLUV-s33892/');
ok(defined($station), "Found station (KLUV).");
my $count = $station->count();
ok((defined($count) && $count > 0), "Found $count streams.");
my @streams = $station->get();
ok($#streams >= 0, "Streams found.");
my $first = $station->get();
ok((defined($first) && defined($first->{'Url'})), "First Stream URL: $$first{'Url'}");
my $best = $station->getBest('Url');
ok((defined($best) && $best =~ /http/), "Best Stream URL: $best");
my @allfields = $station->validFields();
ok($allfields[$#allfields] eq 'Url');
done_testing( $number_of_tests_2run );
