#pragma once
#include <panda/traits.h>

#define _TYPEOF(x) panda::type_of(x).type
#define TYPEOF(x) typename _TYPEOF(x)

namespace panda {

template<typename T> struct remove_pointer       { typedef T type; };
template<typename T> struct remove_pointer<T*>   { typedef typename remove_pointer<T>::type type; };
template<typename T> struct remove_reference     { typedef T type; };
template<typename T> struct remove_reference<T&> { typedef typename remove_reference<T>::type type; };

template<typename T> struct _TypeOfHelper { typedef T type; };

template<typename T> _TypeOfHelper<T> type_of (T& arg) { return _TypeOfHelper<T>(); }

}
