package WWW::ManageWP::Simple;
use strict;
use warnings;
use base 'WWW::ManageWP';
use Email::Valid;

##########
## Core ##
##########

sub list_users {
	my $self = shift;
	return $self->remote->get(method => 'partner/users/list');
}

sub register_user {
	my $self   = shift;
	my $params = $self->_prep_args(['user_email'], @_);
	my $email  = $self->_email_or_die($params->{user_email});
	my %register_params = (user_email => $email);
	foreach my $possible_param (qw/user_pass additional_data plan_id/) {
		if (defined($params->{$possible_param})) {
			$register_params{$possible_param}
				= $params->{$possible_param};
		}
	}
	return $self->remote->post(
		method         => 'partner/users/register',
		request_params => \%register_params,
	);
}

sub remove_user {
	my $self   = shift;
	my $params = $self->_prep_args(['user_email'], @_);
	my $email  = $self->_email_or_die($params->{user_email});
	return $self->remote->delete(
		method         => 'partner/users/remove',
		request_params => {user_email => $email},
	);
}

sub autologin_user {
	my $self   = shift;
	my $params = $self->_prep_args(['user_email'], @_);
	my $email  = $self->_email_or_die($params->{user_email});
	return $self->remote->get(
		method         => 'partner/users/autologintoken',
		request_params => {user_email => $email},
	);
}

sub change_plan {
	my $self   = shift;
	my $params = $self->_prep_args(['user_email', 'plan_id'], @_);
	my $email  = $self->_email_or_die($params->{user_email});
	return $self->remote->post(
		method         => 'partner/users/plan',
		request_params => {
			user_email => $email,
			plan_id    => $params->{plan_id},
		},
	);
}

#############
## Private ##
#############

sub _email_or_die {
	my $self    = shift;
	my $address = shift;
	my $email   = Email::Valid->address($address);
	if (!$email) {
		die "ERROR! email address [$address}] is not valid\n";
	}
	return $email;
}

1;

__END__

=head1 NAME

WWW::ManageWP::Simple;

=head1 DESCRIPTION

A simple wrapper around WWW::ManageWP::Remote to access commmon methods.

=cut

