#!perl
#
# The copyright notice and plain old documentation (POD)
# are at the end of this file.
#
package  Military::SVD;

use strict;
use warnings;
use warnings::register;

use strict;
use warnings;
use warnings::register;

use vars qw($VERSION $DATE);
$VERSION = '1.06';
$DATE = '2003/06/03';

use vars qw($IDENTIFICATION_NUMBER $TITLE $REVISION $REVISION_DATE);
$IDENTIFICATION_NUMBER  = 'DI-IPSC-81442';
$TITLE = 'SOFTWARE VERSION DESCRIPTION (SVD)';
$REVISION = '-';
$REVISION_DATE = '';

1

__END__


=head1 DATA ITEM DESCRIPTION

The following establishes the data general and content
requirements for the identified data item. 

=head1 1. TITLE

SOFTWARE VERSION DESCRIPTION (SVD)

=head1 2. IDENTIFICATION NUMBER

DI-IPSC-81442

=head1 3. DESCRIPTION/PURPOSE

The Software Version Description (SVD) identifies
and describes a software version consisting of one or more Computer
Software Configuration Items (L<CSCI>). It is used to release, track,
and control software versions. 

The term 'version' may be applied to the
initial release of the software, to a subsequent release of that
software, or to one of multiple forms of the software released
at approximately the same time (for example, to different sites).

=head1 7. APPLICATION/INTERRELATIONSHIP

This Data Item Description (DID) contains the
format and content preparation instructions for the data product
generated by specific and discrete task requirements as delineated
in the contract.

This DID is used when the developer is tasked
to identify and record the exact version of software to be delivered
to a user, support, or other site. 

The Contract Data Requirements List (L<CDRL>) should
specify whether deliverable data are to be delivered on paper
or electronic media; are to be in a given electronic form (such
as ASCII, CALS, or compatible with a specified word processor
or other support software); may be delivered in developer format
rather than in the format specified herein; and may reside in
computer-aided software engineering (CASE) or other automated
tool rather than in the form of a traditional document. 

This DID supersedes DI-MCCR-80013A and DI-MCCR-80312.

=head1 10. PREPARATION INSTRUCTIONS 


=head2 10.1 General instructions.


=head2 10.1.1 Automated techniques.

Use of automated techniques
is encouraged. The term 'document' in this DID means
a collection of data regardless of its medium. 

=head2 10.1.2 Alternate presentation styles.

Diagrams, tables,
matrices, and other presentation styles are acceptable substitutes
for text when data required by this DID can be made more readable
using these styles. 

=head2 10.1.3 Title page or identifier with signature blocks.

The document shall include a title page containing, as applicable:
document number; volume number; version/revision indicator; security
markings or other restrictions on the handling of the document;
date; document title; name, abbreviation, and any other identifier
for the systems, subsystems, or items to which the document applies;
contract number; CDRL item number; organization for which the
document has been prepared; name and address of the preparing
organization; distribution statement; and signature blocks for
the developer representative authorized to release the document,
the acquirer representative authorized to approve the document,
and the dates of release/approval. For data in a database or other
alternative form, this information shall be included on external
and internal labels or by equivalent identification methods.

=head2 10.1.4 Table of contents. 

The document shall contain
a table of contents providing the number, title, and page number
of each titled paragraph, figure, table, and appendix. For data
in a database or other alternative form, this information shall
consist of an internal or external table of contents containing
pointers to, or instructions for accessing, each paragraph, figure,
table, and appendix or their equivalents. 

=head2 10.1.5 Page numbering/labeling. 

Each page shall contain
a unique page number and display the document number, including
version, volume, and date, as applicable. For data in a database
or other alternative form, files, screens, or other entities shall
be assigned names or numbers in such a way that desired data can
be indexed and accessed. 

=head2 10.1.6 Response to tailoring instructions. 

If a paragraph
is tailored out of this DID, the resulting document shall contain
the corresponding paragraph number and title, followed by 'This
paragraph has been tailored out.' For data in a database
or other alternative form, this representation need occur only
in the table of contents or equivalent. 

=head2 10.1.7 Multiple paragraphs and subparagraphs. 

Any section, paragraph, or subparagraph in this DID may be written
as multiple paragraphs or subparagraphs to enhance readability.

=head2 10.1.8 Standard data descriptions. 

If a data description
required by this DID has been published in a standard data element
dictionary specified in the contract, reference to an entry in
that dictionary is preferred over including the description itself.

=head2 10.1.9 Substitution of existing documents.

Commercial or other existing documents may be substituted for all or part
of the document if they contain the required data. 

=head2 10.2 Content requirements.

Content requirements begin on the following page. The numbers
shown designate the paragraph numbers to be used in the document.
Each such number is understood to have the prefix '10.2'
within this DID. For example, the paragraph numbered 1.1 is understood
to be paragraph 10.2.1.1 within this DID.

=head1 1 Scope.

This section shall be divided into
the following paragraphs.

=head2 1.1 Identification.

This paragraph shall contain a full
identification of the system and the software to which this document
applies, including, as applicable, identification number(s), title(s),
abbreviation(s), version number(s), and release number(s). It
shall also identify the intended recipients of the SVD to the
extent that this identification affects the contents of the software
released (for example, source code may not be released to all
recipients.)

=head2 1.2 System overview.

This paragraph shall briefly state
the purpose of the system and the software to which this document
applies. It shall describe the general nature of the system and
software; summarize the history of system development, operation,
and maintenance; identify the project sponsor, acquirer, user,
developer, and support agencies; identify current and planned
operating sites; and list other relevant documents.

=head2 1.3 Document overview.

This paragraph shall summarize the
purpose and contents of this document and shall describe any security
or privacy considerations associated with its use.

=head1 2 Referenced documents.

This section shall list the number,
title, revision, and date of all documents referenced in this
document. This section shall also identify the source for all
documents not available through normal Government stocking activities.

=head1 3 Version description.

This section shall be divided into
the following paragraphs.

=head2 3.1 Inventory of materials released.

This paragraph shall list by identifying
numbers, titles, abbreviations, dates, version numbers, and release
numbers, as applicable, all physical media (for example, listings,
tapes, disks) and associated documentation that make up the software
version being released. It shall include applicable security and
privacy considerations for these items, safeguards for handling
them, such as concerns for static and magnetic fields, and instructions
and restrictions regarding duplication and license provisions.

=head2 3.2 Inventory of software contents.

This paragraph shall list by identifying
numbers, titles, abbreviations, dates, version numbers, and release
numbers, as applicable, all computer files that make up the software
version being released. Any applicable security and privacy considerations
shall be included.

=head2 3.3 Changes installed.

This paragraph shall contain a list
of all changes incorporated into the software version since the
previous version. If change classes have been used, such as the
Class I/Class II changes in MIL-STD-973, the changes shall be
separated into these classes. This paragraph shall identify, as
applicable, the problem reports, change proposals, and change
notices associated with each change and the effects, if any, of
each change on system operation and on interfaces with other hardware
and software. This paragraph does not apply to the initial software
version.

=head2 3.4 Adaptation data.

This paragraph shall identify or reference
all unique-to-site data contained in the software version. For
software versions after the first, this paragraph shall describe
changes made to the adaptation data.

=head2 3.5 Related documents.

This paragraph shall list by identifying
numbers, titles, abbreviations, dates, version numbers, and release
numbers, as applicable, all documents pertinent to the software
version being released but not included in the release.

=head2 3.6 Installation instructions.

This paragraph shall provide or reference
the following information, as applicable:

=over 4

=item 1

Instructions for installing the software version

=item 2

Identification of other changes that have
to be installed for this version to be used, including site-unique
adaptation data not included in the software version

=item 3

Security, privacy, or safety precautions relevant
to the installation

=item 4

Procedures for determining whether the version
has been installed properly

=item 5

point of contact to be consulted if there
are problems or questions with the installation

=back

=head2 3.7 Possible problems and known errors.

This paragraph shall identify any
possible problems or known errors with the software version at
the time of release, any steps being taken to resolve the problems
or errors, and instructions (either directly or by reference)
for recognizing, avoiding, correcting, or otherwise handling each
one. The information presented shall be appropriate to the intended
recipient of the SVD (for example, a user agency may need advice
on avoiding errors, a support agency on correcting them).

=head1 4 Notes.

This section shall contain any general
information that aids in understanding this document (e.g., background
information, glossary, rationale). This section shall include
an alphabetical listing of all acronyms, abbreviations, and their
meanings as used in this document and a list of any terms and
definitions needed to understand this document. 

=head1 A. Appendixes.

Appendixes may be used to provide information
published separately for convenience in document maintenance (e.g.,
charts, classified data). As applicable, each appendix shall be
referenced in the main body of the document where the data would
normally have been provided. Appendixes may be bound as separate
documents for ease in handling. Appendixes shall be lettered alphabetically
(A, B, etc.).

=head1 Copyright

This Perl Plain Old Documentation (POD) version is
copyright  2001 2003 Software Diamonds.
This POD version was derived from
the hard copy public domain version freely distributed by
the United States Federal Government.

=head1 License

Software Diamonds permits the redistribution
and use in source and binary forms, with or
without modification, provided that the 
following conditions are met: 

=over 4

=item 1

Redistributions of source code, modified or unmodified
must retain the above copyright notice, this list of
conditions and the following disclaimer. 



=item 2

Redistributions in binary form must 
reproduce the above copyright notice,
this list of conditions and the following 
disclaimer in the documentation and/or
other materials provided with the
distribution.

=back

SOFTWARE DIAMONDS, http://www.SoftwareDiamonds.com,
PROVIDES THIS SOFTWARE 
'AS IS' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL SOFTWARE DIAMONDS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL,EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE,DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING USE OF THIS SOFTWARE, EVEN IF
ADVISED OF NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE POSSIBILITY OF SUCH DAMAGE.

=head1 Copyright Holder Contact

E<lt>support@SoftwareDiamonds.comE<gt>

=for html
<hr>
<p><br>
<!-- BLK ID="PROJECT_MANAGEMENT" -->
<!-- /BLK -->
<p><br>
<!-- BLK ID="NOTICE" -->
<!-- /BLK -->
<p><br>
<!-- BLK ID="OPT-IN" -->
<!-- /BLK -->
<p><br>
<!-- BLK ID="LOG_CGI" -->
<!-- /BLK -->
<p><br>

=cut

## end of file ##
