#!perl
#
# The copyright notice and plain old documentation (POD)
# are at the end of this file.
#
package  Military::OCD;

use strict;
use warnings;
use warnings::register;

use vars qw($VERSION $DATE $IDENTIFICATION_NUMBER $TITLE $REVISION $REVISION_DATE);
$VERSION = '1.05';
$IDENTIFICATION_NUMBER  = 'DI-IPSC-81430 ';
$TITLE = 'OPERATIONAL CONCEPT DESCRIPTION (OCD) ';
$REVISION  = '-';
$DATE = '2003/06/03';
$REVISION_DATE = '';

1


__END__

=head1 DATA ITEM DESCRIPTION

The following establishes the data general and content requirements
for the identified data item. Document style, layout, etc., shall
conform to the Documentation Standard and
an example is provided by Operational concept Description - Model Text.

=head1 1. TITLE

OPERATIONAL CONCEPT DESCRIPTION (OCD) 

=head1 2. IDENTIFICATION NUMBER

DI-IPSC-81430 

=head1 3. DESCRIPTION/PURPOSE

The Operational Concept Description (OCD) describes a proposed
system in terms of the user needs it will fulfill, its relationship
to existing systems or procedures, and the ways it will be used.

The OCD is used to obtain consensus among the acquirer, developer,
support, and user agencies on the operational concept of a proposed
system. Depending on its use, an OCD may focus on communicating
the user's needs to the developer or the developer's ideas to
the user and other interested parties. The term 'system'
may be interpreted to apply to a portion of a system.

=head1 7. APPLICATION/INTERRELATIONSHIP

This Data Item Description (DID) contains the format and content
preparation instructions for the data product generated by specific
and discrete task requirements as delineated in the contract.

This DID is used when the developer is tasked to define and record
the operational concept for a system. 

The Contract Data Requirements List (CDRL) should specify whether
deliverable data are to be delivered on paper or electronic media;
are to be in a given electronic form (such as ASCII, CALS, or
compatible with a specified word processor or other support software);
may be delivered in developer format rather than in the format
specified herein; and may reside in a computer-aided software
engineering (CASE) or other automated tool rather than in the
form of a traditional document. 

This DID supersedes DI-IPSC-80689. 

=head1 10. PREPARATION INSTRUCTIONS 


=head2 10.1 General instructions.


=head2 10.1.1 Automated techniques

Use of automated techniques
is encouraged. The term 'document' in this DID means
a collection of data regardless of its medium. 

=head2 10.1.2 Alternate presentation styles

Diagrams, tables,
matrices, and other presentation styles are acceptable substitutes
for text when data required by this DID can be made more readable
using these styles. 

=head2 10.1.3 Title page or identifier with signature blocks.

The document shall include a title page containing, as applicable:
document number; volume number; version/revision indicator; security
markings or other restrictions on the handling of the document;
date; document title; name, abbreviation, and any other identifier
for the systems, subsystems, or items to which the document applies;
contract number; CDRL item number; organization for which the
document has been prepared; name and address of the preparing
organization; distribution statement; and signature blocks for
the developer representative authorized to release the document,
the acquirer representative authorized to approve the document,
and the dates of release/approval. For data in a database or other
alternative form, this information shall be included on external
and internal labels or by equivalent identification methods.

=head2 10.1.4 Table of contents. 

The document shall contain
a table of contents providing the number, title, and page number
of each titled paragraph, figure, table, and appendix. For data
in a database or other alternative form, this information shall
consist of an internal or external table of contents containing
pointers to, or instructions for accessing, each paragraph, figure,
table, and appendix or their equivalents. 

=head2 10.1.5 Page numbering/labeling. 

Each page shall contain
a unique page number and display the document number, including
version, volume, and date, as applicable. For data in a database
or other alternative form, files, screens, or other entities shall
be assigned names or numbers in such a way that desired data can
be indexed and accessed. 

=head2 10.1.6 Response to tailoring instructions. 

If a paragraph
is tailored out of this DID, the resulting document shall contain
the corresponding paragraph number and title, followed by 'This
paragraph has been tailored out.' For data in a database
or other alternative form, this representation need occur only
in the table of contents or equivalent. 

=head2 10.1.7 Multiple paragraphs and subparagraphs. 

Any section, paragraph, or subparagraph in this DID may be written
as multiple paragraphs or subparagraphs to enhance readability.

=head2 10.1.8 Standard data descriptions. 

If a data description
required by this DID has been published in a standard data element
dictionary specified in the contract, reference to an entry in
that dictionary is preferred over including the description itself.

=head2 10.1.9 Substitution of existing documents.

Commercial or other existing documents may be substituted for all or part
of the document if they contain the required data. 

=head2 10.2 Content requirements.

Content requirements begin on the following page. The numbers
shown designate the paragraph numbers to be used in the document.
Each such number is understood to have the prefix '10.2'
within this DID. For example, the paragraph numbered 1.1 is understood
to be paragraph 10.2.1.1 within this DID.

=head1 1 Scope. 

This section shall be divided into the
following paragraphs. 

=head2 1.1 Identification.

This paragraph shall contain a full identification of the
system to which this document applies, including, as applicable,
identification number(s), title(s), abbreviation(s), version number(s),
and release number(s). 

=head2 1.2 System overview.

This paragraph shall briefly state the purpose of the system
to which this document applies. It shall describe the general
nature of the system; summarize the history of system development,
operation, and maintenance; identify the project sponsor, acquirer,
user, developer, and support agencies; identify current and planned
operating sites; and list other relevant documents. 

=head2 1.3 Document overview

This paragraph shall summarize the purpose and contents of
this document and shall describe any security or privacy considerations
associated with its use. 

=head1 2 Referenced documents.

This section shall list the number, title, revision, and date
of all documents referenced in this document. This section shall
also identify the source for all documents not available through
normal Government stocking activities. 

=head1 3 Current system or situation.

This section shall be divided into the following paragraphs
to describe the system or situation as it currently exists. 

=head2 3.1 Background, objectives, and scope.

This paragraph shall describe the background, mission or objectives,
and scope of the current system or situation. 

=head2 3.2 Operational policies and constraints.

This paragraph shall describe any operational policies and
constraints that apply to the current system or situation. 

=head2 3.3 Description of current system or situation.

This paragraph shall provide a description of the current
system or situation, identifying differences associated with different
states or modes of operation (for example, regular, maintenance,
training, degraded, emergency, alternative-site, wartime, peacetime).
The distinction between states and modes is arbitrary. A system
may be described in terms of states only, modes only, states within
modes, modes within states, or any other scheme that is useful.
If the system operates without states or modes, this paragraph
shall so state, without the need to create artificial distinctions.
The description shall include, as applicable:

=over 4

=item 1

The operational environment and its characteristics

=item 2

Major system components and the interconnections among
these components

=item 3

Interfaces to external systems or procedures

=item 4

Capabilities/functions of the current system

=item 5

Charts and accompanying descriptions depicting inputs,
outputs, data flow, and manual and automated processes sufficient
to understand the current system or situation from the user's
point of view 

=item 6

Performance characteristics, such as speed, throughput,
volume, frequency

=item 7

Quality attributes, such as reliability, maintainability,
availability, flexibility, portability, usability, efficiency

=item 8

Provisions for safety, security, privacy, and continuity
of operations in emergencies

=back

=head2 3.4 Users or involved personnel.

This paragraph shall describe the types of users of the system,
or personnel involved in the current situation, including, as
applicable, organizational structures, training/skills, responsibilities,
activities, and interactions with one another. 

=head2 3.5 Support concept.

This paragraph shall provide an overview of the support concept
for the current system, including, as applicable to this document,
support agency(ies); facilities; equipment; support software;
repair/replacement criteria; maintenance levels and cycles; and
storage, distribution, and supply methods. 

=head1 4 Justification for and nature of changes.

This section shall be divided into the following paragraphs.

=head2 4.1 Justification for change.

This paragraph shall: 

=over 4

=item 1

Describe new or modified aspects of user needs, threats,
missions, objectives, environments, interfaces, personnel or other
factors that require a new or modified system 

=item 2

Summarize deficiencies or limitations in the current system
or situation that make it unable to respond to these factors

=back

=head2 4.2 Description of needed changes.

This paragraph shall summarize new or modified capabilities/functions,
processes, interfaces, or other changes needed to respond to the
factors identified in 4.1. 

=head2 4.3 Priorities among the changes.

This paragraph shall identify priorities among the needed
changes. It shall, for example, identify each change as essential,
desirable, or optional, and prioritize the desirable and optional
changes. 

=head2 4.4 Changes considered but not included.

This paragraph shall identify changes considered but not included
in 4.2, and rationale for not including them. 

=head2 4.5 Assumptions and constraints.

This paragraph shall identify any assumptions and constraints
applicable to the changes identified in this section. 

=head1 5 Concept for a new or modified system.

This section shall be divided into the following paragraphs
to describe a new or modified system.

=head2 5.1 Background, objectives, and scope.

This paragraph shall describe the background, mission or objectives,
and scope of the new or modified system. 

=head2 5.2 Operational policies and constraints.

This paragraph shall describe any operational policies and constraints
that apply to the new or modified system. 

=head2 5.3 Description of the new or modified system.

This paragraph shall provide a description of the new or modified
system, identifying differences associated with different states
or modes of operation (for example, regular, maintenance, training,
degraded, emergency, alternative-site, wartime, peacetime). The
distinction between states and modes is arbitrary. A system may
be described in terms of states only, modes only, states within
modes, modes within states, or any other scheme that is useful.
If the system operates without states or modes, this paragraph
shall so state, without the need to create artificial distinctions.
The description shall include, as applicable: 

=over 4

=item 1

The operational environment and its characteristics

=item 2

Major system components and the interconnections among
these components

=item 3

Interfaces to external systems or procedures

=item 4

Capabilities/functions of the new or modified system

=item 5

Charts and accompanying descriptions depicting inputs,
outputs, data flow, and manual and automated processes sufficient
to understand the new or modified system or situation from the
user's point of view

=item 6

Performance characteristics, such as speed, throughput,
volume, frequency

=item 7

Quality attributes, such as reliability, maintainability,
availability, flexibility, portability, usability, efficiency

=item 8

Provisions for safety, security, privacy, and continuity
of operations in emergencies

=back

=head2 5.4 Users/affected personnel.

This paragraph shall describe the types of users of the new
or modified system, including, as applicable, organizational structures,
training/skills, responsibilities, and interactions with one another.

=head2 5.5 Support concept.

This paragraph shall provide an overview of the support concept
for the new or modified system, including, as applicable, support
agency(ies); facilities; equipment; support software; repair/replacement
criteria; maintenance levels and cycles; and storage, distribution,
and supply methods. 

=head1 6 Operational scenarios.

This section shall describe one or more operational scenarios
that illustrate the role of the new or modified system, its interaction
with users, its interface to other systems, and all states or
modes identified for the system. The scenarios shall include events,
actions, stimuli, information, interactions, etc., as applicable.
Reference may be made to other media, such as videos, to provide
part or all of this information. 

=head1 7 Summary of impacts.

This section shall be divided into the following paragraphs.

=head2 7.1 Operational impacts.

This paragraph shall describe anticipated operational impacts
on the user, acquirer, developer, and support agency(ies). These
impacts may include changes in interfaces with computer operating
centers; change in procedures; use of new data sources; changes
in quantity, type, and timing of data to be input to the system;
changes in data retention requirements; and new modes of operation
based on peacetime, alert, wartime, or emergency conditions. 

=head2 7.2 Organizational impacts.

This paragraph shall describe anticipated organizational impacts
on the user, acquirer, developer, and support agency(ies). These
impacts may include modification of responsibilities; addition
or elimination of responsibilities or positions; need for training
or retraining; and changes in number, skill levels, position identifiers,
or location of personnel in various modes of operation. 

=head2 7.3 Impacts during development.

This paragraph shall describe anticipated impacts on the user,
acquirer, developer, and support agency(ies) during the development
effort. These impacts may include meetings/discussions regarding
the new system; development or modification of databases; training;
parallel operation of the new and existing systems; impacts during
testing of the new system; and other activities needed to aid
or monitor development. 

=head1 8 Analysis of the proposed system.



=head2 8.1 Summary of advantages.

This paragraph shall provide a qualitative and quantitative
summary of the advantages to be obtained from the new or modified
system. This summary shall include new capabilities, enhanced
capabilities, and improved performance, as applicable, and their
relationship to deficiencies identified in 4.1. 

=head2 8.2 Summary of disadvantages/limitations.

This paragraph shall provide a qualitative and quantitative
summary of disadvantages or limitations of the new or modified
system. These disadvantages and limitations shall include, as
applicable, degraded or missing capabilities, degraded or less-than-desired
performance, greater-than-desired use of computer hardware resources,
undesirable operational impacts, conflicts with user assumptions,
and other constraints. 

=head2 8.3 Alternatives and trade-offs considered.

This paragraph shall identify and describe major alternatives
considered to the system or its characteristics, the trade-offs
among them, and rationale for the decisions reached. 

=head1 9 Notes. 

This section shall contain any general
information that aids in understanding this document (e.g., background
information, glossary, rationale). This section shall include
an alphabetical listing of all acronyms, abbreviations, and their
meanings as used in this document and a list of any terms and
definitions needed to understand this document. 

=head1 A. Appendixes. 

Appendixes may be used to provide information
published separately for convenience in document maintenance (e.g.,
charts, classified data). As applicable, each appendix shall be
referenced in the main body of the document where the data would
normally have been provided. Appendixes may be bound as separate
documents for ease in handling. Appendixes shall be lettered alphabetically
(A, B, etc.). 

=head1 Copyright

This Perl Plain Old Documentation (POD) version is
copyright  2001 2003 Software Diamonds.
This POD version was derived from
the hard copy public domain version freely distributed by
the United States Federal Government.

=head1 License

Software Diamonds permits the redistribution
and use in source and binary forms, with or
without modification, provided that the 
following conditions are met: 

=over 4

=item 1

Redistributions of source code, modified or unmodified
must retain the above copyright notice, this list of
conditions and the following disclaimer. 

=item 2

Redistributions in binary form must 
reproduce the above copyright notice,
this list of conditions and the following 
disclaimer in the documentation and/or
other materials provided with the
distribution.

=back

SOFTWARE DIAMONDS, http://www.SoftwareDiamonds.com,
PROVIDES THIS SOFTWARE 
'AS IS' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL SOFTWARE DIAMONDS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL,EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE,DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING USE OF THIS SOFTWARE, EVEN IF
ADVISED OF NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE POSSIBILITY OF SUCH DAMAGE.

=head1 Copyright Holder Contact

E<lt>support@SoftwareDiamonds.comE<gt>

=for html
<hr>
<p><br>
<!-- BLK ID="PROJECT_MANAGEMENT" -->
<!-- /BLK -->
<p><br>
<!-- BLK ID="NOTICE" -->
<!-- /BLK -->
<p><br>
<!-- BLK ID="OPT-IN" -->
<!-- /BLK -->
<p><br>
<!-- BLK ID="LOG_CGI" -->
<!-- /BLK -->
<p><br>

=cut

## end of file ##
