DROP TABLE IF EXISTS Users;
CREATE TABLE Users (
  User INT(10) UNSIGNED ZEROFILL NOT NULL DEFAULT '0000000000',
  Username VARCHAR(50) NOT NULL DEFAULT '',
  Password VARCHAR(16) BINARY NOT NULL DEFAULT '',
  Disabled ENUM('Yes','No') NOT NULL DEFAULT 'No',
  PRIMARY KEY  (User),
  UNIQUE KEY Username (Username),
  FOREIGN KEY (User) REFERENCES UserInfo(ID)
) TYPE=MyISAM PACK_KEYS=1 CHECKSUM=1;

DROP TABLE IF EXISTS UserInfo;
CREATE TABLE UserInfo (
  ID INT(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  Firstname VARCHAR(20) DEFAULT NULL,
  Lastname VARCHAR(30) DEFAULT NULL,
  Email VARCHAR(50) NOT NULL,
  Phone VARCHAR(20) DEFAULT NULL,
  Address1 VARCHAR(100) DEFAULT NULL,
  Address2 VARCHAR(100) DEFAULT NULL,
  City VARCHAR(30) DEFAULT NULL,
  State VARCHAR(20) DEFAULT NULL,
  Country VARCHAR(30) DEFAULT NULL,
  Zip VARCHAR(10) DEFAULT NULL,
  modtime TIMESTAMP(10) NOT NULL,
  regdate DATE NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (ID),
  INDEX (Lastname, Firstname),
  UNIQUE Email (Email)
) TYPE=MyISAM PACK_KEYS=1 CHECKSUM=1;

DROP TABLE IF EXISTS Groups;
CREATE TABLE Groups (
  User INT(10) UNSIGNED ZEROFILL NOT NULL,
  GroupID SMALLINT(3) UNSIGNED ZEROFILL NOT NULL,
  PRIMARY KEY  (User,GroupID),
  FOREIGN KEY (User) REFERENCES UserInfo(ID),
  FOREIGN KEY (GroupID) REFERENCES GroupInfo(ID)
) TYPE=MyISAM PACK_KEYS=1 CHECKSUM=1;

DROP TABLE IF EXISTS GroupInfo;
CREATE TABLE GroupInfo (
  ID SMALLINT(3) UNSIGNED ZEROFILL PRIMARY KEY AUTO_INCREMENT,
  GroupName VARCHAR(15) NOT NULL DEFAULT '',
  Owner INT(10) UNSIGNED ZEROFILL NOT NULL DEFAULT '0000000000',
  Description VARCHAR(75) DEFAULT NULL,
  FOREIGN KEY (Owner) REFERENCES UserInfo(ID)
) TYPE=MyISAM PACK_KEYS=1 CHECKSUM=1;

INSERT INTO GroupInfo VALUES (100,'users',1,
	'Default group. All registered users should be a member of this group');

DROP TABLE IF EXISTS Permissions;
CREATE TABLE Permissions (
  Client SMALLINT(3) UNSIGNED ZEROFILL NOT NULL DEFAULT '000',
  User INT(10) UNSIGNED ZEROFILL NOT NULL DEFAULT '0000000000',
  GroupID SMALLINT(3) UNSIGNED ZEROFILL NOT NULL DEFAULT '000',
  Resource VARCHAR(80) BINARY NOT NULL DEFAULT '',
  MatchKey VARCHAR(50) BINARY NOT NULL DEFAULT '',
  Permissions TINYINT(2) UNSIGNED NOT NULL DEFAULT '0',
  ModTime TIMESTAMP(8) NOT NULL,
  PRIMARY KEY  (Client,User,GroupID,Resource,MatchKey),
  FOREIGN KEY (Client) REFERENCES Clients(ID),
  FOREIGN KEY (User) REFERENCES UserInfo(ID),
  FOREIGN KEY (GroupID) REFERENCES GroupInfo(ID)
) TYPE=MyISAM PACK_KEYS=1 CHECKSUM=1;

INSERT INTO Permissions (GroupID,Resource,Permissions)
	VALUES (100,'/SQCAS/welcom',8);


DROP TABLE IF EXISTS Clients;
CREATE TABLE Clients (
  ID SMALLINT(3) UNSIGNED ZEROFILL PRIMARY KEY AUTO_INCREMENT,
  Name VARCHAR(60) NOT NULL,
  Supplemental_User_Table VARCHAR(60),
  Domain VARCHAR(255) NOT NULL,
  Base_Path VARCHAR(255) NOT NULL DEFAULT '/',
  Admin INT UNSIGNED ZEROFILL NOT NULL,
  Description VARCHAR(255),
  Cookie_Name VARCHAR(60) NOT NULL,
  Timeout MEDIUMINT UNSIGNED NOT NULL DEFAULT 900,
  UNIQUE (Domain),
  FOREIGN KEY (Admin) REFERENCES UserInfo(ID)
) TYPE=MyISAM PACK_KEYS=1 CHECKSUM=1;


DROP TABLE IF EXISTS Session;
CREATE TABLE Session (
  ID VARCHAR(32) BINARY NOT NULL PRIMARY KEY,
  User INT(10) UNSIGNED ZEROFILL DEFAULT NULL,
  TS TIMESTAMP(14) NOT NULL,
  IP VARCHAR(15) NOT NULL,
  KEY User (User),
  FOREIGN KEY (User) REFERENCES UserInfo(ID)
) TYPE=MyISAM PACK_KEYS=1 CHECKSUM=1;


