
use strict;
use 5.008001;
use lib ".";
use inc::Module::Install;

name        'PAR';
abstract    'Perl Archive Tookit';
all_from    'lib/PAR.pm';
repository  'https://github.com/rschupp/PAR';

perl_version '5.008001';
requires    'File::Temp'        => 0.05;
requires    'Compress::Zlib'    => ($^O eq 'MSWin32') ? 1.16 : 1.30;
requires    'Archive::Zip'      => 1.00;
requires    'PAR::Dist'         => 0.32;
requires    'AutoLoader'        => '5.66_02';

if (can_use('Crypt::OpenPGP') or can_run('gpg')) {
    my $has_sha1 = (
        can_use('Digest::SHA1') or
        can_use('Digest::SHA')  or
        can_use('Digest::SHA::PurePerl')
    );

    feature 'Digital signature support',
    recommends
            'Digest',
            ($has_sha1 ? () : (can_cc() ? 'Digest::SHA'
                                        : 'Digest::SHA::PurePerl')),
            'Module::Signature';
}

no_index    directory => 'contrib';
auto_provides;

clean_files 't/hello.par';

WriteAll sign => 0;

sub MY::postamble {
    return <<'...';
all :: 
	$(PERL) t/gen-hello-par.pl
...
}
