use Test::More tests => 1;
my $sa = SA::Stub->new();
my $expected_response = q(<alignment name="PF08001" alignType="PfamFull" max="30"><alignObject objectVersion="7742c75899e7887415b4ffc42eaf7477" intObjectId="Q80KP4" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFEDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="c20988ce56202bec5d7cee2985a1d1a6" intObjectId="Q7TD97" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>NSVDNLRRLHYEYRHLELGVVIAIRMAMVLLLGYVLARTVYHVSSAYYLRWHACVPQKCEKSLC</sequence></alignObject><alignObject objectVersion="e33d631aa9490571307f3a57930cc10d" intObjectId="P09727" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MNLVMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLSDVSEYRVEYSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDVSESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW</sequence></alignObject><alignObject objectVersion="136763e18853f8aa76825c846764b4bc" intObjectId="Q80KN6" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVFSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="f178a4bd65cede40b5a6ec9fc74d6528" intObjectId="Q805K4" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFRDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="165b3e8fd4b66ca0483aa87440297b0b" intObjectId="Q80KP3" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFRDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSAIHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="803fda2f7a179fce0ab9141e04153070" intObjectId="P09730" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MRRWLRLLVGLGCCWVTLAHAGNPYEDDDYYYYREDEPRQHGEPNYVAPPARQFRFPPLNNVSSYQASCVVKDGVLDAVWRVQGTFYPEKGIVARVGWSGRRGRKWGRLHAPECLVETTEAVFRLRQWVPTDLDHLTLHLVPCTKCKPMWCQPRYHIRYFSYGNSVDNLRRLHYEYRHLELGVVIAICMAMVLLLGYVLARTVYRVSSAYYLRWHACVPQKCEKSLC</sequence></alignObject><alignObject objectVersion="c711eb0cf28bb84aa4c583b23679088a" intObjectId="Q8QRU8" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MRLGLLWITLCSAVRGEDVCPRSWSLPYANETVPRTAKKTTTDTVPGFPPWPDISGYAVEHSGVQCVIRHGGKLEALWILRGNFSAKGPVPKAYYRYDGGVSEDIPLQDVSGDTAASVRRYWLYGYPVRVDLRRVFFYFQPCYRCHAHWTECEPAAAVPWLPLWSSFHDVRRLLHESRRLTAYYVMFVKSFQYTLMCVMAIQVFWGTCVQTWPYHDRPWLIWDHM</sequence></alignObject><alignObject objectVersion="34fa26fcd76c2c451980a2c77feb0b68" intObjectId="Q805I6" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRG</sequence></alignObject><alignObject objectVersion="35853d2cd15a5b086768fcb2c86d3f87" intObjectId="P09731" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MRIQLLLVATLVASIVATRVEDMATFRTEKQWQQDLQYRREFVKRQLAPKPKSNIVVSHTVSCVIDGGNMTSVWRFEGQFNPHIASEVILHDTSGLYNVPHEIQNDGQVLTVTVKRSAPADIAKVLISLKPVQLSSGQYECRPQLQLPWVPRPSSFMYDSYRLWYEKRWLTIILYVFMWTYLVTLLQYCIVRFIGTRLFYFLQRNITIRFTGKPTYNLLTYPVKG</sequence></alignObject><alignObject objectVersion="348bbd8ae112a753160e22f36bbb9cbe" intObjectId="Q80KN5" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWVNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRG</sequence></alignObject><alignObject objectVersion="ed0e77b54203cf8f4f1ddf548b689315" intObjectId="Q8QRV0" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MQLKESQSLIWHCCVIAVSVLSGRSRETSFRVSGDESASDRTCPTSSPYSSQSVRLPPYPHPVGDNVSRYRVQSSVSECYVQHGTLVAVWAVRGNFSEPFPRVYGTWGNERSASHFQVDEPRIETDGTRRYEVELPQVDARISYVMLNVYPCSTCNRSSLHCQPVLRLPWLPLRTTSSDLERLFVEQRYVLLAYVVLVQFLKHVALFTFGIQLACCVYLRYVRPRTRRHRRRHPAGRITAAAATVTVTPHEETEKNR</sequence></alignObject><alignObject objectVersion="e3699a228ab1196054346ed761679f25" intObjectId="Q80KP2" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPKAYGTWGNERSATHFKVGAPRLENDGALRYETEIPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="e56fd2daea6a40e477022a1d0bb455a2" intObjectId="Q80KN9" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFEDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPRSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="80ea8bb4750eb472cc3539fc08ce0546" intObjectId="Q6SVZ5" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MNLVMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLPDVSEYRVEYSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDISESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW</sequence></alignObject><alignObject objectVersion="6ca52ed351478dfd8b95e1a75143b134" intObjectId="Q6RXB4" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MNLVMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLPDVSEYRVESSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDVSESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW</sequence></alignObject><alignObject objectVersion="477cfa64625a0b034b99f2bc3ba36b64" intObjectId="Q8QRV1" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MGVPCLVWCFAVLLCVWGALCAAEDDYGEDDYEGFSSQRHAFLYRNKVDTYEADCVVRDGVLEAEWRVRGSFFPEDGLLGRVSWQGHRGRRWGHLEAPRREVSRDSATFRLTQRVPPELDYLILNIIPCMRCKPLWCEPRYHIRYLNYGTSMDNLQRLHYEYRHWELGFVLGLQLLAVLMLGYVFAKMVYELSRYHYMRYHACVPQKCHPVKPLY</sequence></alignObject><alignObject objectVersion="44a84f821a29c2e2f2d0744ead48f1bb" intObjectId="Q8QRV2" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MWTQLHVFLLCLTAVTGYGRRKLSRREIALDFMNSEAWESDLIAGRLEFKKFMRPYPKNNMILSHTVSCTIYGGNMTGIWHLEGQFYPSILSEIILTDSDGSYEFIPHKATVTEQSLSVEIKHPVSLTVSHVSLRVFPVKFSQEYYSCTPTVELPWIPQFSFYEYDSYRLSHEGRFISLCFYVMIWAYLITLALCATPLFWVKVFEMLRRGIKARYAGSVRRNSLFYAAKCQ</sequence></alignObject><alignObject objectVersion="6604cf9f90bbd6c3284009f770ea87f8" intObjectId="Q8UZK5" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MNLIMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLPDVSEYRVEYSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDISESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW</sequence></alignObject><alignObject objectVersion="274d9ae44486bb0fa8891ea4936dcd85" intObjectId="P09729" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="709eb4910606bafcdc5b3c9dcd4aeade" intObjectId="Q80KP1" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="749a2129882f737de6c876cee834e546" intObjectId="Q80KN8" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLKFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRG</sequence></alignObject><alignObject objectVersion="1916192f42ddb7354380f562457fd58d" intObjectId="Q6RXB7" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MRRWLRLLVGLGCCWVTLAHAGNPYEDNDYYYYREDEPRQHGEPNYVAPPARQFRFPPLNNVSSYQASCVVKDGVLDAVWRVQGTFYPEKGIVARVGWSGRHGRKWGRLQAPECLVETTEAVFRLRQWVPTDLDHLTLHLVPCSKCKPMWCQPRYHIRYFSYGNSVDNLRRLHYEYRHLELGVVIAIQMAMVLLLGYVLARTVYRVSSAYYLRWHACVPQKCEKSLC</sequence></alignObject><alignObject objectVersion="1f0dd48bfdf5d5912d5a798366f1b348" intObjectId="Q6SVZ8" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MRRWLRLLVGLGCCWVTLAHAGNPYEDDDYYYYREDEPRQHGEPNYVAPPARQFRFPPLNNVSSYQASCVVKDGVLDAVWRVQGTFYPEKGIVARVGWSGRRGRKWGRLHAPECLVETTEAVFRLRQWVPTDLDHLTLHLVPCTKCKPMWCQPRYHIRYFSYGNSVDNLRRLHYEYRHLELGVVIAIQMAMVLLLGYVLARTVYRVSSAYYLRWHACVPQKCEKSLC</sequence></alignObject><alignObject objectVersion="88f2880135c11e393a8d4d3a168980f7" intObjectId="Q80KN7" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETEIPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHHATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="c418d3b017752ef2a5bed5574e242078" intObjectId="Q80KP0" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNXRSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="280f861f71d1e1b591051c99aa76bf1d" intObjectId="Q6RXB8" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MRIQLLLVSTLVACIVAKRVEDMATFRTEKQWQQDLQYQREFVKRQLAPKPKSNIVVSHTVSCVIDGGNMTSVWRFEGQFNPHIASEVILHDTSGLYNVPHEVQNDGQVLTVTVKRSVRADIAKVLISLKPVKLSSREYECRPQLQLPWIPRPSSFMYDSYRLWYEKRWLTIILYVLMWTYLVMLLQYCIVRFIGTRLFYFLQRNITIRFTGKPTYNLLTYPVKG</sequence></alignObject><alignObject objectVersion="bdbb3fc31dbb233f34fdd623ff4050f2" intObjectId="Q6SVZ9" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MRIQLLLVSTLVASIVATRVEDMATFRTEKQWQQDLQYRREFVKRQLAPKPKSNIVVSHTVSCVIDGGNMTSVWRFEGQFNPHIASEVILHDTSGLYNVPHEVQNDGQVLTVTVKRSAPADIAKVLISLKPVQLSSGQYECRPQLQLPWVPRPSSFMYDSYRLWYEKRWLTIILYVFMWTYLVTLLQYCIVRFIGTRLFYFLQRNITIRFTGKPTYNLLTYPVKG</sequence></alignObject><alignObject objectVersion="274d9ae44486bb0fa8891ea4936dcd85" intObjectId="Q6Y835" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD</sequence></alignObject><alignObject objectVersion="c506d39d1cfb621956e7aafa785123aa" intObjectId="Q80KP5" type="Protein sequence" dbSource="Pfam" dbVersion="20.0" dbAccessionId="PF08001" dbCoordSys="UniProt"><sequence>MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFRDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGKTSREEEAKDD</sequence></alignObject><block blockOrder="1" ><segment intObjectId="Q80KP4" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q7TD97" start="1" end="64"><cigar>31D6I6DI2D2I7D4I5D5I9D2I9D5ID5I4DI14D3I38D2I3DID5I18D2I4DI14D4MD23MI10M4D5MI10M5I5MD3M2D4M</cigar></segment><segment intObjectId="P09727" start="1" end="215"><cigar>4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M</cigar></segment><segment intObjectId="Q80KN6" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI16M5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q805K4" start="12" end="236"><cigar>7M2D13MD8M6I6MI11M4I5M5I9M2I9M5IM5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q80KP3" start="12" end="236"><cigar>7M2D13MD8M6I6MI11M4I5M5I9M2I9M5IM5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="P09730" start="1" end="227"><cigar>7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q8QRU8" start="1" end="221"><cigar>4M2DM8D7M2D19MI2M2I2M4DM4I5M5I9M2I9M5I25M3I3MD15MD4M2D12M2I3MI24M2I23MD23MI5MD4M4D4MDI8D2M5I15M</cigar></segment><segment intObjectId="Q805I6" start="12" end="232"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5M7D3M</cigar></segment><segment intObjectId="P09731" start="1" end="225"><cigar>4M5D13M3D6M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14M2D17M2I3MID5I18M2I4MI42MI19MI10M5I15M</cigar></segment><segment intObjectId="Q80KN5" start="12" end="232"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5M7D3M</cigar></segment><segment intObjectId="Q8QRV0" start="1" end="249"><cigar>7M2D13M2D7M6I9M2I16M5I26M5I4MI20M2D3M2D28M2I3MIM5I24MID17MD34M2D7MI30M</cigar></segment><segment intObjectId="Q80KP2" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q80KN9" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q6SVZ5" start="1" end="215"><cigar>4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M</cigar></segment><segment intObjectId="Q6RXB4" start="1" end="215"><cigar>4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M</cigar></segment><segment intObjectId="Q8QRV1" start="1" end="215"><cigar>31M6I6MI2M2I2M5D4I5D5I6D3M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD9M</cigar></segment><segment intObjectId="Q8QRV2" start="1" end="231"><cigar>7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14MD18M2I3MID5I18M2I4MI42MI5MD13MI10M5I15M</cigar></segment><segment intObjectId="Q8UZK5" start="1" end="215"><cigar>4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M</cigar></segment><segment intObjectId="P09729" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q80KP1" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q80KN8" start="12" end="232"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5M7D3M</cigar></segment><segment intObjectId="Q6RXB7" start="1" end="227"><cigar>7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q6SVZ8" start="1" end="227"><cigar>7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q80KN7" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q80KP0" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q6RXB8" start="1" end="225"><cigar>4M5D13M3D6M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14M2D17M2I3MID5I18M2I4MI42MI19MI10M5I15M</cigar></segment><segment intObjectId="Q6SVZ9" start="1" end="225"><cigar>4M5D13M3D6M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14M2D17M2I3MID5I18M2I4MI42MI19MI10M5I15M</cigar></segment><segment intObjectId="Q6Y835" start="12" end="236"><cigar>7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment><segment intObjectId="Q80KP5" start="12" end="236"><cigar>7M2D13MD8M6I6MI11M4I5M5I9M2I9M5IM5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M</cigar></segment></block></alignment>);


#open(my $o1, ">out1"); print $o1 $expected_response; close($o1);
#open(my $o2, ">out2"); print $o2 $sa->das_alignment->({'query'=>'PF08001'}); close($o2);
my $response = $sa->das_alignment({
				   'query' => ['test'],
				  });

#fix screwed up line-endings somewhere
$expected_response =~ s/[\r\n]+/\n/smg;
$response          =~ s/[\r\n]+/\n/smg;

is_deeply($response, $expected_response, "alignments");


package SA::Stub;
use base qw(Bio::Das::ProServer::SourceAdaptor);
use Data::Dumper;

sub build_alignment {
  my $self = shift;

  my @data = ();
  while(my $line = <DATA>) {
    chomp $line;
    my @parts = split(/\s+/, $line);
    my $ref   = {};
    for my $f (qw(pfamseq_acc pfamseq_id md5 sequence cigar tree_order seq_start seq_end)) {
      $ref->{$f} = shift @parts;
    }
    push @data, $ref;
  }

  my @aliObjects;
  my %seen;
  my @segments;
  foreach my $row (@data){
    if(!$seen{$row->{'pfamseq_acc'}}){
      my @objectDetails;
      
      push(@aliObjects, {'version' => $row->{'md5'},
			 'intID' => $row->{'pfamseq_acc'},
			 'type' => "Protein sequence",
			 'dbSource' => "Pfam",
			 'dbVersion' => "20.0",
			 'coos' => "UniProt",
			 'accession' =>  "PF08001",
			 'aliObjectDetail' => \@objectDetails,
			 'sequence' => $row->{'sequence'}});
      
      $seen{$row->{'pfamseq_acc'}}++;
    }
    
    push(@segments, { 'cigar'    => $row->{'cigar'},
		      'objectId' => $row->{'pfamseq_acc'},
		      'start'    => $row->{'seq_start'},
		      'end'      => $row->{'seq_end'}, });
  }
  
  my @blocks;
  push(@blocks, {'blockOrder' => 1,
		 'segments' => \@segments
		});
  
  my @ali;
  push(@ali,  {
	       'type' => "PfamFull",
	       'name' => "PF08001",
	       'max' => scalar @data,
	       'alignObj' => \@aliObjects,
	       'blocks' => \@blocks,
	       'scores' => undef,
	       'geo3D' => undef, #Normally an array
	      });

  return @ali;
}

1;

__DATA__
Q80KP4  Q80KP4_HCMV     7742c75899e7887415b4ffc42eaf7477        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFEDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        12      12      236
Q7TD97  Q7TD97_HCMV     c20988ce56202bec5d7cee2985a1d1a6        NSVDNLRRLHYEYRHLELGVVIAIRMAMVLLLGYVLARTVYHVSSAYYLRWHACVPQKCEKSLC        31D6I6DI2D2I7D4I5D5I9D2I9D5ID5I4DI14D3I38D2I3DID5I18D2I4DI14D4MD23MI10M4D5MI10M5I5MD3M2D4M       7       1       64
P09727  US11_HCMVA      e33d631aa9490571307f3a57930cc10d        MNLVMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLSDVSEYRVEYSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDVSESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW  4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M      4       1       215
Q80KN6  Q80KN6_HCMV     136763e18853f8aa76825c846764b4bc        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVFSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI16M5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M 18      12      236
Q805K4  Q805K4_HCMV     f178a4bd65cede40b5a6ec9fc74d6528        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFRDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M2D13MD8M6I6MI11M4I5M5I9M2I9M5IM5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M  25      12      236
Q80KP3  Q80KP3_HCMV     165b3e8fd4b66ca0483aa87440297b0b        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFRDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSAIHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M2D13MD8M6I6MI11M4I5M5I9M2I9M5IM5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M  24      12      236
P09730  US08_HCMVA      803fda2f7a179fce0ab9141e04153070        MRRWLRLLVGLGCCWVTLAHAGNPYEDDDYYYYREDEPRQHGEPNYVAPPARQFRFPPLNNVSSYQASCVVKDGVLDAVWRVQGTFYPEKGIVARVGWSGRRGRKWGRLHAPECLVETTEAVFRLRQWVPTDLDHLTLHLVPCTKCKPMWCQPRYHIRYFSYGNSVDNLRRLHYEYRHLELGVVIAICMAMVLLLGYVLARTVYRVSSAYYLRWHACVPQKCEKSLC      7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD3M2D4M   9       1       227
Q8QRU8  Q8QRU8_9BETA    c711eb0cf28bb84aa4c583b23679088a        MRLGLLWITLCSAVRGEDVCPRSWSLPYANETVPRTAKKTTTDTVPGFPPWPDISGYAVEHSGVQCVIRHGGKLEALWILRGNFSAKGPVPKAYYRYDGGVSEDIPLQDVSGDTAASVRRYWLYGYPVRVDLRRVFFYFQPCYRCHAHWTECEPAAAVPWLPLWSSFHDVRRLLHESRRLTAYYVMFVKSFQYTLMCVMAIQVFWGTCVQTWPYHDRPWLIWDHM        4M2DM8D7M2D19MI2M2I2M4DM4I5M5I9M2I9M5I25M3I3MD15MD4M2D12M2I3MI24M2I23MD23MI5MD4M4D4MDI8D2M5I15M 5       1       221
Q805I6  Q805I6_HCMV     34fa26fcd76c2c451980a2c77feb0b68        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRG 7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5M7D3M   23      12      232
P09731  US07_HCMVA      35853d2cd15a5b086768fcb2c86d3f87        MRIQLLLVATLVASIVATRVEDMATFRTEKQWQQDLQYRREFVKRQLAPKPKSNIVVSHTVSCVIDGGNMTSVWRFEGQFNPHIASEVILHDTSGLYNVPHEIQNDGQVLTVTVKRSAPADIAKVLISLKPVQLSSGQYECRPQLQLPWVPRPSSFMYDSYRLWYEKRWLTIILYVFMWTYLVTLLQYCIVRFIGTRLFYFLQRNITIRFTGKPTYNLLTYPVKG        4M5D13M3D6M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14M2D17M2I3MID5I18M2I4MI42MI19MI10M5I15M     29      1       225
Q80KN5  Q80KN5_HCMV     348bbd8ae112a753160e22f36bbb9cbe        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWVNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRG 7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5M7D3M   22      12      232
Q8QRV0  Q8QRV0_9BETA    ed0e77b54203cf8f4f1ddf548b689315        MQLKESQSLIWHCCVIAVSVLSGRSRETSFRVSGDESASDRTCPTSSPYSSQSVRLPPYPHPVGDNVSRYRVQSSVSECYVQHGTLVAVWAVRGNFSEPFPRVYGTWGNERSASHFQVDEPRIETDGTRRYEVELPQVDARISYVMLNVYPCSTCNRSSLHCQPVLRLPWLPLRTTSSDLERLFVEQRYVLLAYVVLVQFLKHVALFTFGIQLACCVYLRYVRPRTRRHRRRHPAGRITAAAATVTVTPHEETEKNR        7M2D13M2D7M6I9M2I16M5I26M5I4MI20M2D3M2D28M2I3MIM5I24MID17MD34M2D7MI30M  11      1       249
Q80KP2  Q80KP2_HCMV     e3699a228ab1196054346ed761679f25        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPKAYGTWGNERSATHFKVGAPRLENDGALRYETEIPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        19      12      236
Q80KN9  Q80KN9_HCMV     e56fd2daea6a40e477022a1d0bb455a2        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFEDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPRSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        13      12      236
Q6SVZ5  Q6SVZ5_HCMV     80ea8bb4750eb472cc3539fc08ce0546        MNLVMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLPDVSEYRVEYSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDISESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW  4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M      2       1       215
Q6RXB4  Q6RXB4_HCMV     6ca52ed351478dfd8b95e1a75143b134        MNLVMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLPDVSEYRVESSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDVSESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW  4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M      3       1       215
Q8QRV1  Q8QRV1_9BETA    477cfa64625a0b034b99f2bc3ba36b64        MGVPCLVWCFAVLLCVWGALCAAEDDYGEDDYEGFSSQRHAFLYRNKVDTYEADCVVRDGVLEAEWRVRGSFFPEDGLLGRVSWQGHRGRRWGHLEAPRREVSRDSATFRLTQRVPPELDYLILNIIPCMRCKPLWCEPRYHIRYLNYGTSMDNLQRLHYEYRHWELGFVLGLQLLAVLMLGYVFAKMVYELSRYHYMRYHACVPQKCHPVKPLY  31M6I6MI2M2I2M5D4I5D5I6D3M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD9M       6       1       215
Q8QRV2  Q8QRV2_9BETA    44a84f821a29c2e2f2d0744ead48f1bb        MWTQLHVFLLCLTAVTGYGRRKLSRREIALDFMNSEAWESDLIAGRLEFKKFMRPYPKNNMILSHTVSCTIYGGNMTGIWHLEGQFYPSILSEIILTDSDGSYEFIPHKATVTEQSLSVEIKHPVSLTVSHVSLRVFPVKFSQEYYSCTPTVELPWIPQFSFYEYDSYRLSHEGRFISLCFYVMIWAYLITLALCATPLFWVKVFEMLRRGIKARYAGSVRRNSLFYAAKCQ 7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14MD18M2I3MID5I18M2I4MI42MI5MD13MI10M5I15M       27      1       231
Q8UZK5  US11_HCMVT      6604cf9f90bbd6c3284009f770ea87f8        MNLIMLILALWAPVAGSMPELSLTLFDEPPPLVETEPLPPLPDVSEYRVEYSEARCVLRSGGRLEALWTLRGNLSVPTPTPRVYYQTLEGYADRVPTPVEDISESLVAKRYWLRDYRVPQRTKLVLFYFSPCHQCQTYYVECEPRCLVPWVPLWSSLEDIERLLFEDRRLMAYYALTIKSAQYTLMMVAVIQVFWGLYVKGWLHRHFPWMFSDQW  4M6D12M3D6M6I6MI2M2I2M5D4I5D5ID8M2I9M5I25M2I4M2D14MD25M5I18M2I23MD23MI5MD4M4D16M5I2D3M4D6M      1       1       215
P09729  US09_HCMVA      274d9ae44486bb0fa8891ea4936dcd85        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        16      12      236
Q80KP1  Q80KP1_HCMV     709eb4910606bafcdc5b3c9dcd4aeade        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        14      12      236
Q80KN8  Q80KN8_HCMV     749a2129882f737de6c876cee834e546        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLKFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRG 7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5M7D3M   21      12      232
Q6RXB7  Q6RXB7_HCMV     1916192f42ddb7354380f562457fd58d        MRRWLRLLVGLGCCWVTLAHAGNPYEDNDYYYYREDEPRQHGEPNYVAPPARQFRFPPLNNVSSYQASCVVKDGVLDAVWRVQGTFYPEKGIVARVGWSGRHGRKWGRLQAPECLVETTEAVFRLRQWVPTDLDHLTLHLVPCSKCKPMWCQPRYHIRYFSYGNSVDNLRRLHYEYRHLELGVVIAIQMAMVLLLGYVLARTVYRVSSAYYLRWHACVPQKCEKSLC      7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD3M2D4M   10      1       227
Q6SVZ8  Q6SVZ8_HCMV     1f0dd48bfdf5d5912d5a798366f1b348        MRRWLRLLVGLGCCWVTLAHAGNPYEDDDYYYYREDEPRQHGEPNYVAPPARQFRFPPLNNVSSYQASCVVKDGVLDAVWRVQGTFYPEKGIVARVGWSGRRGRKWGRLHAPECLVETTEAVFRLRQWVPTDLDHLTLHLVPCTKCKPMWCQPRYHIRYFSYGNSVDNLRRLHYEYRHLELGVVIAIQMAMVLLLGYVLARTVYRVSSAYYLRWHACVPQKCEKSLC      7M2D22M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I38M2I3MIM5I18M2I4MID17MD23MI10M4D5MI10M5I5MD3M2D4M   8       1       227
Q80KN7  Q80KN7_HCMV     88f2880135c11e393a8d4d3a168980f7        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETEIPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHHATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        20      12      236
Q80KP0  Q80KP0_HCMV     c418d3b017752ef2a5bed5574e242078        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNXRSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        15      12      236
Q6RXB8  Q6RXB8_HCMV     280f861f71d1e1b591051c99aa76bf1d        MRIQLLLVSTLVACIVAKRVEDMATFRTEKQWQQDLQYQREFVKRQLAPKPKSNIVVSHTVSCVIDGGNMTSVWRFEGQFNPHIASEVILHDTSGLYNVPHEVQNDGQVLTVTVKRSVRADIAKVLISLKPVKLSSREYECRPQLQLPWIPRPSSFMYDSYRLWYEKRWLTIILYVLMWTYLVMLLQYCIVRFIGTRLFYFLQRNITIRFTGKPTYNLLTYPVKG        4M5D13M3D6M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14M2D17M2I3MID5I18M2I4MI42MI19MI10M5I15M     30      1       225
Q6SVZ9  Q6SVZ9_HCMV     bdbb3fc31dbb233f34fdd623ff4050f2        MRIQLLLVSTLVASIVATRVEDMATFRTEKQWQQDLQYRREFVKRQLAPKPKSNIVVSHTVSCVIDGGNMTSVWRFEGQFNPHIASEVILHDTSGLYNVPHEVQNDGQVLTVTVKRSAPADIAKVLISLKPVQLSSGQYECRPQLQLPWVPRPSSFMYDSYRLWYEKRWLTIILYVFMWTYLVTLLQYCIVRFIGTRLFYFLQRNITIRFTGKPTYNLLTYPVKG        4M5D13M3D6M6I6MI2M2I7M4I5M5I9M2I9M5IM5I4MI14M3I3M2D14M2D17M2I3MID5I18M2I4MI42MI19MI10M5I15M     28      1       225
Q6Y835  Q6Y835_HCMV     274d9ae44486bb0fa8891ea4936dcd85        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSNSKSVRLPQYPRGFGDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRVTPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGRTSREEEAKDD  7M8D7M2D7M6I6MI2M2I2M2D3M4I19MI10M5I10MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M        17      12      236
Q80KP5  Q80KP5_HCMV     c506d39d1cfb621956e7aafa785123aa        MILWSPSTCSFFWHWCLIAVSVLSSRSKESLRLSWSSDESSASSSSRICPLSDSKSVRLPQYPRGFRDVSGYRVSSSVSECYVQHGVLVAAWLVRGNFSDTAPRAYGTWGNERSATHFKVGAPQLENDGALRYETELPQVDARLSYVMLTVYPCSACNRSVLHCRPASRLPWLPLRATPSDLERLFAERRYLTFLYVVLVQFVKHVALFSFGVQVACCVYLRWIRPWVRGRHRATGKTSREEEAKDD  7M2D13MD8M6I6MI11M4I5M5I9M2I9M5IM5I4MI20M4D31M2I3MIM5I24MID17MD23MI5M3D2M2D5M2DID9M5I5MD3M2D4M  26      12      236
