#!/usr/bin/perl

use strict;
use ExtUtils::MakeMaker;
use Config;

# Switch to default behavior if STDIN isn't a tty.

unless (-t STDIN) {
  warn(
    "\n",
    "=============================================\n\n",
    "STDIN is not a terminal.  Assuming --default.\n\n",
    "=============================================\n\n",
  );
  push @ARGV, "--default";
}

# Remind the user she can use --default.

unless (grep /^--default$/, @ARGV) {
  warn(
    "\n",
    "=============================================\n\n",
    "Prompts may be bypassed by running:\n",
    "   $^X $0 --default\n\n",
    "=============================================\n\n",
  );
}

# Should we skip the network tests?

my $prompt = (
  "Some of POE's tests require a functional network.\n" .
  "You can skip these tests if you'd like.\n\n" .
  "Would you like to skip the network tests?"
);

my $ret = "n";
if (grep /^--default$/, @ARGV) {
  print $prompt, " [$ret] $ret\n\n";
}
else {
  $ret = prompt($prompt, "n");
}

my $marker = 'run_network_tests';
unlink $marker;
unless ($ret =~ /^Y$/i) {
  open(TOUCH,"+>$marker") and close TOUCH;
}

print "\n";

# Which kind of makefile should we build?

if ($] < 5.005004) {
  warn(
    "\n",
    "===============================================================\n",
    "\n",
    "Please upgrade Perl to avoid lapses in support.  Perl 5.005_04\n",
    "or newer is preferred.  Support for older versions will be\n",
    "phased out in the future.\n",
    "\n",
    "Thank you.\n",
    "\n",
    "===============================================================\n",
    "\n",
  );

  require "./mylib/Makefile-5004.pm";
}
else {
  require "./mylib/Makefile-5005.pm";
}

1;
