package Statocles::Page;
{
  $Statocles::Page::VERSION = '0.005';
}
# ABSTRACT: Render documents into HTML

use Statocles::Role;
use Statocles::Template;
use Text::Markdown;

requires 'render';


has path => (
    is => 'ro',
    isa => Str,
);


has markdown => (
    is => 'ro',
    isa => InstanceOf['Text::Markdown'],
    default => sub { Text::Markdown->new },
);

my @template_attrs = (
    is => 'ro',
    isa => InstanceOf['Statocles::Template'],
    coerce => sub {
        die "Template is undef" unless defined $_[0];
        return !ref $_[0]
            ? Statocles::Template->new( content => $_[0] )
            : $_[0]
            ;
    },
);


has template => @template_attrs;


has layout => (
    @template_attrs,
    default => sub {
        Statocles::Template->new( content => '<%= $content %>' ),
    },
);

1;

__END__

=pod

=head1 NAME

Statocles::Page - Render documents into HTML

=head1 VERSION

version 0.005

=head1 DESCRIPTION

A Statocles::Page takes one or more documents and renders them into one or more
HTML pages.

=head1 ATTRIBUTES

=head2 path

The absolute URL path to save this page to.

=head2 markdown

The L<Text::Markdown> object to render document Markdown.

=head2 template

The main template for this page. The result will be wrapped in the C<layout>
template.

=head2 layout

The layout template for this page, which will wrap the content generated by the
C<template>.

=head1 SEE ALSO

=over

=item L<Statocles::Page::Document>

A page that renders a single document.

=item L<Statocles::Page::List>

A page that renders a list of other pages.

=back

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
