# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package AddressBook::GEN::Child;

use strict;

use base 'AddressBook';

use AddressBook::Model::child qw(
    $CHILD
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Child' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my $retval = {
        headings       => [
            'Name',
            'Birth Day',
        ],
        header_options => [
            {
                text => 'Add',
                link => $real_location . "add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $CHILD->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->name,
                    $row->birth_day,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $real_location . "edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $real_location . "delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $CHILD->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'name',
                label => 'Name',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'birth_day',
                label => 'Birth Day',
                type => 'text',
                is => 'date',
            },
            {
                options => $selections->{family},
                name => 'family',
                label => 'Family',
                type => 'select',
                is => 'int4',
            },
        ],
    };
} # END form

1;

=head1 NAME

AddressBook::GEN::Child - generated support module for AddressBook::Child

=head1 SYNOPSIS

In AddressBook::Child:

    use base 'AddressBook::GEN::Child';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in AddressBook::Child to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

