use strict;
use warnings;

use Module::Build;

my $build = Module::Build->new(
   module_name => 'Tickit::Widget::Scroller',
   requires => {
      'String::Tagged' => 0,
      'Tickit::RenderBuffer' => '0.43', # flush_to_term
      'Tickit::Test' => '0.12',
      'Tickit::Widget' => '0.35',
      'Tickit::Window' => '0.42',
      'Tickit::Pen' => '0.19',
   },
   build_requires => {
      'Test::More' => '0.88', # done_testing
   },
   auto_configure_requires => 0, # Don't add M::B to configure_requires
   license => 'perl',
   create_makefile_pl => 'traditional',
   create_license => 1,
   create_readme  => 1,
);

$build->create_build_script;
