package Sah::SchemaR::share;

our $DATE = '2020-06-04'; # DATE
our $VERSION = '0.011'; # VERSION

our $rschema = ["float",[{description=>"\nAccepted in one of these forms:\n\n    0.5      # a normal float between 0 and 1\n    10       # a float between 1 (exclusive) and 100, interpreted as percent\n    10%      # a percentage string, between 0% and 100%\n\nDue to different interpretations, particularly \"1\" (some people might expect it\nto mean \"0.01\" or \"1%\") use of this type is discouraged. Use\n<pm:Sah::Schema::percent> instead.\n\n",examples=>[{valid=>1,validated_value=>0,value=>0},{valid=>1,validated_value=>0.5,value=>0.5},{valid=>1,validated_value=>1,value=>1},{valid=>1,validated_value=>0.012,value=>1.2},{valid=>1,validated_value=>0.012,value=>"1.2%"},{valid=>0,value=>"102%"}],max=>1,min=>0,summary=>"A float between 0 and 1","x.perl.coerce_rules"=>["From_str::share"]}],["float"]];

1;
# ABSTRACT: A float between 0 and 1

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::share - A float between 0 and 1

=head1 VERSION

This document describes version 0.011 of Sah::SchemaR::share (from Perl distribution Sah-Schemas-Float), released on 2020-06-04.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Float>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Float>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Float>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019, 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
