#!perl

use 5.010001;
use strict;
use warnings;

use Data::Sah::Resolve qw(resolve_schema);
use Test::Exception;
use Test::More 0.98;

test_resolve(
    name   => "unknown -> dies",
    schema => "foo",
    dies => 1,
);

test_resolve(
    schema => "example::recurse1",
    dies => 1,
);
test_resolve(
    schema => "example::recurse2a",
    dies => 1,
);
test_resolve(
    schema => "example::recurse2b",
    dies => 1,
);

test_resolve(
    schema => "int",
    result => ["int", []],
);
test_resolve(
    schema => ["int"],
    result => ["int", []],
);
test_resolve(
    schema => ["int", {}],
    result => ["int", []],
);
test_resolve(
    schema => ["int", min=>2],
    result => ["int", [{min=>2}]],
);

test_resolve(
    schema => "posint",
    result => ["int", [{summary=>"Positive integer (1, 2, ...)", min=>1}]],
);
test_resolve(
    schema => ["posint", min=>10],
    result => ["int", [{summary=>"Positive integer (1, 2, ...)", min=>1}, {min=>10}]],
);
test_resolve(
    schema => ["posint", "merge.delete.min"=>undef],
    result => ["int", [{summary=>"Positive integer (1, 2, ...)"}]],
);

test_resolve(
    schema => ["poseven"],
    result => ["int", [{summary=>"Positive integer (1, 2, ...)", min=>1}, {summary=>"Positive even number", div_by=>2}]],
);
test_resolve(
    schema => ["poseven", min=>10, div_by=>3],
    result => ["int", [{summary=>"Positive integer (1, 2, ...)", min=>1}, {summary=>"Positive even number", div_by=>2}, {min=>10, div_by=>3}]],
);
test_resolve(
    name   => "2 merges",
    schema => ["example::has_merge", {"merge.normal.div_by"=>3}],
    result => ["int", [{summary=>"Even integer", div_by=>3}]],
);

# XXX test error in merging -> dies

DONE_TESTING:
done_testing;

sub test_resolve {
    my %args = @_;

    subtest $args{name} => sub {
        my $res;
        if ($args{dies}) {
            dies_ok { resolve_schema($args{schema}) } "resolve dies"
                or return;
        } else {
            lives_ok { $res = resolve_schema($args{schema}) } "resolve lives"
                or return;
        }
        if ($args{result}) {
            is_deeply($res, $args{result}, "result")
                or diag explain $res;
        }
    };
}
