package Bencher::Scenario::RefUtil;

our $DATE = '2016-04-30'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Ref::Util',
    precision => 0.001,
    participants => [
        {
            name=>'is_arrayref',
            module => 'Ref::Util',
            code_template => 'no warnings "void"; state $ref = []; Ref::Util::is_arrayref($ref) for 1..1000',
        },
        {
            name=>'is_plain_arrayref',
            module => 'Ref::Util',
            code_template => 'no warnings "void"; state $ref = []; Ref::Util::is_plain_arrayref($ref) for 1..1000',
        },
        {
            name=>'ref(ARRAY)',
            code_template => 'no warnings "void"; state $ref = []; ref($ref) eq "ARRAY" for 1..1000',
        },
        {
            name=>'reftype(ARRAY)',
            module => 'Scalar::Util',
            code_template => 'no warnings "void"; state $ref = []; Scalar::Util::reftype($ref) eq "ARRAY" for 1..1000',
        },
    ],
};

1;
# ABSTRACT: Benchmark Ref::Util

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RefUtil - Benchmark Ref::Util

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::RefUtil (from Perl distribution Bencher-Scenarios-RefUtil), released on 2016-04-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m RefUtil

To run module startup overhead benchmark:

 % bencher --module-startup -m RefUtil

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Ref::Util> 0.011

L<Scalar::Util> 1.45

=head1 BENCHMARK PARTICIPANTS

=over

=item * is_arrayref (perl_code)

Code template:

 no warnings "void"; state $ref = []; Ref::Util::is_arrayref($ref) for 1..1000



=item * is_plain_arrayref (perl_code)

Code template:

 no warnings "void"; state $ref = []; Ref::Util::is_plain_arrayref($ref) for 1..1000



=item * ref(ARRAY) (perl_code)

Code template:

 no warnings "void"; state $ref = []; ref($ref) eq "ARRAY" for 1..1000



=item * reftype(ARRAY) (perl_code)

Code template:

 no warnings "void"; state $ref = []; Scalar::Util::reftype($ref) eq "ARRAY" for 1..1000



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m RefUtil >>):

 +-------------------+-----------+-----------+------------+---------+---------+
 | participant       | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------------+-----------+-----------+------------+---------+---------+
 | reftype(ARRAY)    | 1.63e+04  | 61.4      | 1          | 6.1e-08 | 62      |
 | is_plain_arrayref | 23721.5   | 42.1559   | 1.45726    | 0       | 20      |
 | is_arrayref       | 24868.4   | 40.2116   | 1.52772    | 9.2e-12 | 23      |
 | ref(ARRAY)        | 2.6e+04   | 38.4      | 1.6        | 3.1e-08 | 34      |
 +-------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m RefUtil --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Scalar::Util        | 5.34      | 2.94                   | 1          | 5.2e-06 | 212     |
 | Ref::Util           | 5.02      | 2.62                   | 1.06       | 4.9e-06 | 329     |
 | perl -e1 (baseline) | 2.4       | 0                      | 2.22       | 2.4e-06 | 131     |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARK NOTES

I'm not seeing significant performance difference between C<ref() eq "ARRAY">
and C<is_arrayref()> on my perls. Am I doing something wrong?

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-RefUtil>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-RefUtil>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-RefUtil>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
