package Bencher::Scenario::PerinciEnvRes;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.04'; # VERSION

our $scenario = {
    summary => 'Compare returning enveloped result vs naked/list',
    participants => [
        {name=>'envres'             , code_template => 'return [200, "OK", "foo"]'},
        {name=>'envres_with_resmeta', code_template => 'return [200, "OK", "foo", {}]'},
        {name=>'str'                , code_template => 'return "foo"'},
        {name=>'list'               , code_template => 'return (200, "OK", "foo")', result_is_list=>1},
    ],
};

# ABSTRACT: Compare returning enveloped result vs naked/list

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PerinciEnvRes - Compare returning enveloped result vs naked/list

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::PerinciEnvRes (from Perl distribution Bencher-Scenarios-Perinci), released on 2016-06-26.

=head1 SYNOPSIS

=head1 BENCHMARK PARTICIPANTS

=over

=item * envres (perl_code)

Code template:

 return [200, "OK", "foo"]



=item * envres_with_resmeta (perl_code)

Code template:

 return [200, "OK", "foo", {}]



=item * str (perl_code)

Code template:

 return "foo"



=item * list (perl_code)

Code template:

 return (200, "OK", "foo")



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PerinciEnvRes >>):

 +---------------------+-----------+-----------+------------+---------+---------+
 | participant         | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +---------------------+-----------+-----------+------------+---------+---------+
 | envres_with_resmeta |   3444520 |   290.317 |     1      |   0     |      20 |
 | envres              |   5198820 |   192.351 |     1.5093 |   0     |      21 |
 | list                | 130000000 |     7.4   |    39      | 2.6e-11 |      20 |
 | str                 | 400000000 |     2     |   100      | 2.6e-11 |      20 |
 +---------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Perinci>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Perinci>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Perinci>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
