package Bencher::Scenario::PERLANCAR::pass_list_vs_array;

our $DATE = '2016-04-13'; # DATE
our $VERSION = '0.05'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark passing list vs array reference',
    description => <<'_',


_
    participants => [
        {
            name=>'pass_list',
            code_template=>'my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(@list) }',
        },
        {
            name=>'pass_arrayref',
            code_template=>'my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(\@list) }',
        },
    ],

    datasets => [
        {name => 'data', args => {'size@'=>[100, 1000, 10000], 'reuse@'=>[1, 10, 100, 1000]}},
    ],
};

1;
# ABSTRACT: Benchmark passing list vs array reference

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::pass_list_vs_array - Benchmark passing list vs array reference

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::PERLANCAR::pass_list_vs_array (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-04-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::pass_list_vs_array

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * pass_list (perl_code)

Code template:

 my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(@list) }



=item * pass_arrayref (perl_code)

Code template:

 my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(\@list) }



=back

=head1 BENCHMARK DATASETS

=over

=item * data

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::pass_list_vs_array >>):

 +---------------+-----------+----------+------------+-----------+------------+---------+---------+
 | participant   | arg_reuse | arg_size | rate (/s)  | time (ms) | vs_slowest | errors  | samples |
 +---------------+-----------+----------+------------+-----------+------------+---------+---------+
 | pass_list     | 1000      | 10000    | 46         | 22        | 1          | 4.4e-05 | 23      |
 | pass_list     | 100       | 10000    | 4.4e+02    | 2.3       | 9.5        | 1.1e-05 | 20      |
 | pass_list     | 1000      | 1000     | 5.9e+02    | 1.7       | 13         | 5.7e-06 | 21      |
 | pass_list     | 10        | 10000    | 2.48e+03   | 0.403     | 53.4       | 2.1e-07 | 20      |
 | pass_list     | 100       | 1000     | 3e+03      | 0.33      | 65         | 4.2e-07 | 21      |
 | pass_arrayref | 1000      | 10000    | 3.4e+03    | 0.29      | 74         | 9.1e-07 | 20      |
 | pass_list     | 1000      | 100      | 4.17e+03   | 0.24      | 89.6       | 2.1e-07 | 20      |
 | pass_list     | 1         | 10000    | 4788.26    | 0.208844  | 102.987    | 9.2e-11 | 20      |
 | pass_arrayref | 100       | 10000    | 4.95e+03   | 0.202     | 106        | 4.9e-08 | 24      |
 | pass_arrayref | 10        | 10000    | 5.13e+03   | 0.195     | 110        | 5.3e-08 | 20      |
 | pass_arrayref | 1         | 10000    | 5300.23    | 0.188671  | 113.998    | 0       | 25      |
 | pass_arrayref | 1000      | 1000     | 8135.48    | 0.122918  | 174.98     | 5.7e-11 | 20      |
 | pass_arrayref | 1000      | 100      | 9349.71    | 0.106955  | 201.096    | 0       | 20      |
 | pass_list     | 10        | 1000     | 2.67e+04   | 0.0374    | 575        | 1.3e-08 | 21      |
 | pass_arrayref | 100       | 1000     | 33701      | 0.029673  | 724.84     | 5.8e-11 | 20      |
 | pass_list     | 100       | 100      | 3.91e+04   | 0.0256    | 840        | 1.1e-08 | 27      |
 | pass_list     | 1         | 1000     | 44833      | 0.022305  | 964.28     | 4.6e-11 | 20      |
 | pass_arrayref | 10        | 1000     | 4.78e+04   | 0.0209    | 1.03e+03   | 6.7e-09 | 20      |
 | pass_arrayref | 1         | 1000     | 5.13e+04   | 0.0195    | 1.1e+03    | 5.6e-09 | 28      |
 | pass_arrayref | 100       | 100      | 7.98e+04   | 0.0125    | 1.72e+03   | 5.7e-09 | 27      |
 | pass_list     | 10        | 100      | 2.248e+05  | 0.004448  | 4835       | 8e-11   | 36      |
 | pass_arrayref | 10        | 100      | 3.1659e+05 | 0.0031586 | 6809.3     | 1.1e-11 | 27      |
 | pass_list     | 1         | 100      | 3.962e+05  | 0.002524  | 8521.5     | 1.1e-11 | 20      |
 | pass_arrayref | 1         | 100      | 4.2e+05    | 0.00238   | 9.04e+03   | 7.5e-10 | 25      |
 +---------------+-----------+----------+------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Passing a large array by reference will generate a large saving only if we reuse
the list (pass it multiple times).

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
